module Msf
  ###
  #
  # The remote exploit class is a specialization of the exploit module class
  # that is geared toward exploits that are performed against targets other than
  # the local machine.  This typically implies exploiting other machines via a
  # network connection, though it is not limited to this scope.
  #
  ###
  class Exploit::Remote < Exploit
    include Msf::Exploit::AutoTarget

    #
    # Initializes the socket array.
    #
    def initialize(info)
      super

      self.sockets = Array.new
    end

    #
    # Returns the fact that this exploit is a remote exploit.
    #
    def exploit_type
      Exploit::Type::Remote
    end

    #
    # Adds a socket to the list of sockets opened by this exploit.
    #
    def add_socket(sock)
      self.sockets << sock
    end

    #
    # Removes a socket from the list of sockets.
    #
    def remove_socket(sock)
      self.sockets.delete(sock)
    end

    #
    # This method is called once a new session has been created on behalf of
    # this exploit instance and all socket connections created by this
    # exploit should be closed.
    #
    def abort_sockets
      sockets.delete_if { |sock|

        begin
          sock.close
        rescue ::Exception
        end
        true
      }
    end

    protected

    #
    # The list of sockets established by this exploit.
    #
    attr_accessor :sockets

  end
end