/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExport;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrFileMetadata;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\b\u0010\rB!\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0010J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExport;", "exportingName", "", "containingFile", "packageFqName", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "name", "file", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/library/SerializedIrFile;)V", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "decl", "(Ljava/lang/String;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getExportingName", "()Ljava/lang/String;", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "containingPackageFqName", "getContainingPackageFqName", "fqName", "getFqName", "render", "Companion", "ir.serialization.js"})
@SourceDebugExtension(value={"SMAP\nJsKlibExportingDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsKlibExportingDeclaration.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class JsKlibExportingDeclaration
extends JsKlibExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String exportingName;
    @Nullable
    private final IrDeclaration declaration;
    @NotNull
    private final String containingPackageFqName;
    @NotNull
    private final String fqName;

    public JsKlibExportingDeclaration(@NotNull String exportingName, @NotNull String containingFile, @NotNull String packageFqName, @Nullable IrDeclaration declaration) {
        String it;
        String string;
        Intrinsics.checkNotNullParameter(exportingName, "exportingName");
        Intrinsics.checkNotNullParameter(containingFile, "containingFile");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        super(containingFile);
        this.exportingName = exportingName;
        this.declaration = declaration;
        String string2 = string = packageFqName;
        JsKlibExportingDeclaration jsKlibExportingDeclaration = this;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual(it, "<root>");
        String string3 = bl2 ? string : null;
        if (string3 == null) {
            string3 = "";
        }
        jsKlibExportingDeclaration.containingPackageFqName = string3;
        it = string = ".";
        StringBuilder stringBuilder = new StringBuilder().append(this.containingPackageFqName);
        jsKlibExportingDeclaration = this;
        boolean bl3 = false;
        boolean bl4 = ((CharSequence)this.containingPackageFqName).length() > 0;
        String string4 = bl4 ? string : null;
        if (string4 == null) {
            string4 = "";
        }
        jsKlibExportingDeclaration.fqName = stringBuilder.append(string4).append(this.exportingName).toString();
    }

    @NotNull
    public final String getExportingName() {
        return this.exportingName;
    }

    @Nullable
    public final IrDeclaration getDeclaration() {
        return this.declaration;
    }

    public JsKlibExportingDeclaration(@NotNull String name2, @NotNull SerializedIrFile file) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(file, "file");
        this(name2, file.getPath(), file.getFqName(), null);
    }

    public JsKlibExportingDeclaration(@NotNull String name2, @NotNull IrFile file, @NotNull IrDeclaration decl) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(decl, "decl");
        this(name2, file.getFileEntry().getName(), file.getPackageFqName().toString(), decl);
    }

    @NotNull
    public final String getContainingPackageFqName() {
        return this.containingPackageFqName;
    }

    @Override
    @NotNull
    public String getFqName() {
        return this.fqName;
    }

    @Override
    @NotNull
    public String render() {
        return "exporting name '" + this.exportingName + "' from file '" + this.getContainingFile() + '\'';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration$Companion;", "", "<init>", "()V", "collectDeclarations", "", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration;", "cleanFiles", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "dirtyFiles", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "exportedNames", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "ir.serialization.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<JsKlibExportingDeclaration> collectDeclarations(@NotNull List<SerializedIrFile> cleanFiles, @NotNull List<? extends IrFile> dirtyFiles, @NotNull Map<IrFile, ? extends Map<IrDeclarationWithName, String>> exportedNames) {
            List<JsKlibExportingDeclaration> list;
            Intrinsics.checkNotNullParameter(cleanFiles, "cleanFiles");
            Intrinsics.checkNotNullParameter(dirtyFiles, "dirtyFiles");
            Intrinsics.checkNotNullParameter(exportedNames, "exportedNames");
            List<JsKlibExportingDeclaration> $this$collectDeclarations_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (SerializedIrFile serializedIrFile : cleanFiles) {
                JsIrFileMetadata fileMetadata = JsIrFileMetadata.Companion.fromByteArray(KlibKt.getFileMetadata(serializedIrFile));
                for (String string : fileMetadata.getExportedNames()) {
                    $this$collectDeclarations_u24lambda_u240.add(new JsKlibExportingDeclaration(string, serializedIrFile));
                }
            }
            for (IrFile irFile : dirtyFiles) {
                Map<IrDeclarationWithName, String> exportedDeclarations;
                if (exportedNames.get(irFile) == null) continue;
                for (Map.Entry entry : exportedDeclarations.entrySet()) {
                    IrDeclarationWithName declaration = (IrDeclarationWithName)entry.getKey();
                    String exportedName = (String)entry.getValue();
                    $this$collectDeclarations_u24lambda_u240.add(new JsKlibExportingDeclaration(exportedName, irFile, declaration));
                }
            }
            return CollectionsKt.build(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

