/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.Locking;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.LockingClauseStrategy;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class TeradataSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private final boolean supportsLocking = this.getDialect().getVersion().isSameOrAfter(14);

    public TeradataSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        LockingClauseStrategy lockingClauseStrategy;
        super.visitQuerySpec(querySpec);
        if (querySpec.isRoot() && this.supportsLocking && this.needsLocking(querySpec) && (lockingClauseStrategy = this.getLockingClauseStrategy()) != null) {
            lockingClauseStrategy.render(arg_0 -> ((TeradataSqlAstTranslator)this).prependSql(arg_0));
        }
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, Locking.FollowOn followOnStrategy) {
        if (!this.supportsLocking) {
            return AbstractSqlAstTranslator.LockStrategy.NONE;
        }
        if (followOnStrategy == Locking.FollowOn.FORCE) {
            return AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        return super.determineLockingStrategy(querySpec, followOnStrategy);
    }

    protected void visitForUpdateClause(QuerySpec querySpec) {
    }

    protected boolean needsRowsToSkip() {
        return true;
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true, true);
        super.visitSqlSelections(selectClause);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }
}

