/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;

public class RemoteIPAttribute
implements ExchangeAttribute {
    public static final String REMOTE_IP_SHORT = "%a";
    public static final String REMOTE_IP = "%{REMOTE_IP}";
    public static final ExchangeAttribute INSTANCE = new RemoteIPAttribute();

    private RemoteIPAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        SocketAddress sourceAddress = exchange.request().remoteAddress();
        if (sourceAddress == null) {
            return null;
        }
        return sourceAddress.host();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Remote IP", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Remote IP";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RemoteIPAttribute.REMOTE_IP) || token.equals(RemoteIPAttribute.REMOTE_IP_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

