/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.function.Predicate;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.rotation.KeyLocator;

public class SamlMetadataKeyLocator
implements KeyLocator {
    private final String modelKey;
    private final PublicKeyLoader loader;
    private final PublicKeyStorageProvider keyStorage;
    private final KeyUse use;

    public SamlMetadataKeyLocator(String modelKey, PublicKeyLoader loader, KeyUse use, PublicKeyStorageProvider keyStorage) {
        this.modelKey = modelKey;
        this.loader = loader;
        this.keyStorage = keyStorage;
        this.use = use;
    }

    public Key getKey(String kid) throws KeyManagementException {
        if (kid == null) {
            return null;
        }
        KeyWrapper keyWrapper = this.keyStorage.getFirstPublicKey(this.modelKey, this.sameKidPredicate(kid), this.loader);
        return keyWrapper != null ? keyWrapper.getPublicKey() : null;
    }

    public Key getKey(Key key) throws KeyManagementException {
        if (key == null) {
            return null;
        }
        KeyWrapper keyWrapper = this.keyStorage.getFirstPublicKey(this.modelKey, this.sameKeyPredicate(key), this.loader);
        return keyWrapper != null ? keyWrapper.getPublicKey() : null;
    }

    public void refreshKeyCache() {
        this.keyStorage.reloadKeys(this.modelKey, this.loader);
    }

    public Iterator<Key> iterator() {
        return this.keyStorage.getKeys(this.modelKey, this.loader).stream().filter(k -> this.isSameUse((KeyWrapper)k) && this.isValidCertificate((KeyWrapper)k)).map(KeyWrapper::getPublicKey).iterator();
    }

    private Predicate<KeyWrapper> sameKidPredicate(String kid) {
        return keyWrapper -> this.isSameKid((KeyWrapper)keyWrapper, kid);
    }

    private boolean isSameKid(KeyWrapper keyWrapper, String kid) {
        String k = keyWrapper.getKid();
        if (k == null) {
            return false;
        }
        return k.equals(kid) && this.isSameUse(keyWrapper) && this.isValidCertificate(keyWrapper);
    }

    private Predicate<KeyWrapper> sameKeyPredicate(Key key) {
        return keyWrapper -> this.isSameKey((KeyWrapper)keyWrapper, key);
    }

    private boolean isSameKey(KeyWrapper keyWrapper, Key key) {
        Key k = keyWrapper.getPublicKey();
        if (k == null) {
            return false;
        }
        return this.isSameUse(keyWrapper) && key.getAlgorithm().equals(k.getAlgorithm()) && MessageDigest.isEqual(k.getEncoded(), key.getEncoded()) && this.isValidCertificate(keyWrapper);
    }

    private boolean isSameUse(KeyWrapper k) {
        if (k == null) {
            return false;
        }
        return k.getUse() == null || k.getUse().equals((Object)this.use);
    }

    private boolean isValidCertificate(KeyWrapper key) {
        if (key == null || key.getCertificate() == null) {
            return false;
        }
        try {
            key.getCertificate().checkValidity();
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }
}

