/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.clientpolicy.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.executor.SecureCibaSignedAuthenticationRequestExecutor;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;

public class SecureCibaSignedAuthenticationRequestExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "secure-ciba-signed-authn-req";
    public static final String AVAILABLE_PERIOD = "available-period";
    private static final ProviderConfigProperty AVAILABLE_PERIOD_PROPERTY = new ProviderConfigProperty("available-period", "Available Period", "The maximum period in seconds for which the 'request' signed authentication request used in CIBA backchannel authentication request is considered valid.", "String", (Object)"3600");

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new SecureCibaSignedAuthenticationRequestExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The executor checks whether the client treats the signed authentication request in its CIBA backchannel authentication request by following Financial-grade API CIBA Security Profile.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new ArrayList<ProviderConfigProperty>(Arrays.asList(AVAILABLE_PERIOD_PROPERTY));
    }
}

