/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Iterator;
import java.util.function.Predicate;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.CloseableIterator;

public class FilterIterator<E>
extends AbstractIterator<E>
implements CloseableIterator<E> {
    private final Iterator<E> iter;
    private final Predicate<? super E> filter;

    public FilterIterator(Iterator<E> iter, Predicate<? super E> filter) {
        this.iter = iter;
        this.filter = filter;
    }

    @Override
    protected E getNext() {
        while (this.iter.hasNext()) {
            E next = this.iter.next();
            if (!this.filter.test(next)) continue;
            return next;
        }
        return null;
    }

    @Override
    public void close() {
        if (this.iter instanceof CloseableIterator) {
            ((CloseableIterator)this.iter).close();
        }
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

