/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.stat;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.stat.SimpleStat;
import org.infinispan.commons.stat.TimerTracker;

public class DefaultSimpleStat
implements SimpleStat {
    private volatile Data data = new Data();

    @Override
    public void record(long value) {
        this.data.record(value);
    }

    @Override
    public long getMin(long defaultValue) {
        return this.data.getMin(defaultValue);
    }

    @Override
    public long getMax(long defaultValue) {
        return this.data.getMax(defaultValue);
    }

    @Override
    public long getAverage(long defaultValue) {
        return this.data.getAvg(defaultValue);
    }

    @Override
    public long count() {
        return this.data.count();
    }

    @Override
    public void setTimer(TimerTracker timer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.data = new Data();
    }

    private static class Data {
        private final LongAdder count = new LongAdder();
        private final LongAdder sum = new LongAdder();
        private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
        private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);

        private Data() {
        }

        void record(long value) {
            this.updateMin(value);
            this.updateMax(value);
            this.sum.add(value);
            this.count.increment();
        }

        long getMin(long defaultValue) {
            return this.count() == 0L ? defaultValue : this.min.get();
        }

        long getMax(long defaultValue) {
            return this.count() == 0L ? defaultValue : this.max.get();
        }

        long getAvg(long defaultValue) {
            long c = this.count();
            return c == 0L ? defaultValue : this.sum.sum() / c;
        }

        long count() {
            return this.count.sum();
        }

        private void updateMin(long value) {
            long tmp = this.min.get();
            while (value < tmp) {
                if (this.min.compareAndSet(tmp, value)) {
                    return;
                }
                tmp = this.min.get();
            }
        }

        private void updateMax(long value) {
            long tmp = this.max.get();
            while (value > tmp) {
                if (this.max.compareAndSet(tmp, value)) {
                    return;
                }
                tmp = this.max.get();
            }
        }
    }
}

