/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging.events;

import java.util.Optional;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.util.logging.events.EventLog;

public class EventLogSerializer
implements ConfigurationSerializer<EventLog> {
    @Override
    public void serialize(ConfigurationWriter writer, EventLog event) {
        writer.writeStartElement("log");
        writer.writeAttribute("category", event.getCategory().name());
        writer.writeStartElement("content");
        writer.writeAttribute("level", event.getLevel().name());
        writer.writeAttribute("message", event.getMessage());
        writer.writeAttribute("detail", this.unwrap(event.getDetail()));
        writer.writeEndElement();
        writer.writeStartElement("meta");
        writer.writeAttribute("instant", event.getWhen().toString());
        writer.writeAttribute("context", this.unwrap(event.getContext()));
        writer.writeAttribute("scope", this.unwrap(event.getScope()));
        writer.writeAttribute("who", this.unwrap(event.getWho()));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private String unwrap(Optional<String> optional) {
        return optional.orElse(null);
    }
}

