/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.changes.CacheHolder;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangesUtils;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.SessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.transaction.DatabaseUpdate;
import org.keycloak.models.sessions.infinispan.transaction.NonBlockingTransaction;

public class InfinispanChangelogBasedTransaction<K, V extends SessionEntity>
implements SessionsChangelogBasedTransaction<K, V>,
NonBlockingTransaction {
    public static final Logger logger = Logger.getLogger(InfinispanChangelogBasedTransaction.class);
    protected final KeycloakSession kcSession;
    protected final Map<K, SessionUpdatesList<V>> updates = new HashMap<K, SessionUpdatesList<V>>();
    protected final CacheHolder<K, V> cacheHolder;

    public InfinispanChangelogBasedTransaction(KeycloakSession kcSession, CacheHolder<K, V> cacheHolder) {
        this.kcSession = kcSession;
        this.cacheHolder = cacheHolder;
    }

    @Override
    public void addTask(K key, SessionUpdateTask<V> task) {
        SessionUpdatesList<Object> myUpdates = this.updates.get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.cacheHolder.cache().get(key);
            if (wrappedEntity == null) {
                logger.tracef("Not present cache item for key %s", key);
                return;
            }
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.updates.put(key, myUpdates);
        }
        task.runUpdate(myUpdates.getEntityWrapper().getEntity());
        myUpdates.add(task);
    }

    public void addTask(K key, SessionUpdateTask<V> task, V entity, UserSessionModel.SessionPersistenceState persistenceState) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)entity).getRealmId());
        SessionEntityWrapper<V> wrappedEntity = new SessionEntityWrapper<V>(entity);
        SessionUpdatesList<V> myUpdates = new SessionUpdatesList<V>(realm, wrappedEntity, persistenceState);
        this.updates.put(key, myUpdates);
        if (task != null) {
            task.runUpdate(entity);
            myUpdates.add(task);
        }
    }

    @Deprecated(since="26.4", forRemoval=true)
    public void reloadEntityInCurrentTransaction(RealmModel realm, K key, SessionEntityWrapper<V> entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        SessionEntityWrapper latestEntity = (SessionEntityWrapper)this.cacheHolder.cache().get(key);
        if (latestEntity == null) {
            return;
        }
        SessionUpdatesList newUpdates = new SessionUpdatesList(realm, latestEntity);
        SessionUpdatesList<V> existingUpdates = this.updates.get(key);
        if (existingUpdates != null) {
            newUpdates.setUpdateTasks(existingUpdates.getUpdateTasks());
        }
        this.updates.put(key, newUpdates);
    }

    public SessionEntityWrapper<V> get(K key) {
        SessionUpdatesList<Object> myUpdates = this.updates.get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.cacheHolder.cache().get(key);
            if (wrappedEntity == null) {
                return null;
            }
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.updates.put(key, myUpdates);
            return wrappedEntity;
        }
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().map(SessionUpdateTask::getOperation).anyMatch(SessionUpdateTask.CacheOperation.REMOVE::equals);
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    @Override
    public void asyncCommit(AggregateCompletionStage<Void> stage, Consumer<DatabaseUpdate> databaseUpdates) {
        for (Map.Entry<K, SessionUpdatesList<V>> entry : this.updates.entrySet()) {
            long maxIdleTimeMs;
            SessionUpdatesList<V> sessionUpdates = entry.getValue();
            SessionEntityWrapper<V> sessionWrapper = sessionUpdates.getEntityWrapper();
            List updateTasks = sessionUpdates.getUpdateTasks();
            if (updateTasks.isEmpty() || sessionUpdates.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT || updateTasks.get(0).getOperation().equals((Object)SessionUpdateTask.CacheOperation.ADD_IF_ABSENT) && updateTasks.get(updateTasks.size() - 1).getOperation().equals((Object)SessionUpdateTask.CacheOperation.REMOVE)) continue;
            RealmModel realm = sessionUpdates.getRealm();
            long lifespanMs = this.cacheHolder.lifespanFunction().apply(realm, sessionUpdates.getClient(), sessionWrapper.getEntity());
            MergedUpdate merged = MergedUpdate.computeUpdate(updateTasks, sessionWrapper, lifespanMs, maxIdleTimeMs = this.cacheHolder.maxIdleFunction().apply(realm, sessionUpdates.getClient(), sessionWrapper.getEntity()).longValue());
            if (merged == null) continue;
            InfinispanChangesUtils.runOperationInCluster(this.cacheHolder, entry.getKey(), merged, sessionWrapper, stage, logger);
        }
    }

    @Override
    public void asyncRollback(AggregateCompletionStage<Void> stage) {
        this.updates.clear();
    }

    public Cache<K, SessionEntityWrapper<V>> getCache() {
        return this.cacheHolder.cache();
    }

    public V importSession(RealmModel realmModel, K key, SessionEntityWrapper<V> session, long lifespan, long maxIdle) {
        SessionUpdatesList<V> updatesList = this.updates.get(key);
        if (updatesList != null) {
            return updatesList.getEntityWrapper().getEntity();
        }
        SessionEntityWrapper existing = (SessionEntityWrapper)this.cacheHolder.cache().putIfAbsent(key, session, lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
        if (existing == null) {
            this.updates.put(key, new SessionUpdatesList<V>(realmModel, session));
            return null;
        }
        this.updates.put(key, new SessionUpdatesList(realmModel, existing));
        return (V)existing.getEntity();
    }

    public void importSessionsConcurrently(RealmModel realmModel, Map<K, SessionEntityWrapper<V>> sessions, SessionFunction<V> lifespanFunction, SessionFunction<V> maxIdleFunction) {
        if (sessions.isEmpty()) {
            return;
        }
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
        ConcurrentHashMap<Object, SessionEntityWrapper> allSessions = new ConcurrentHashMap<Object, SessionEntityWrapper>();
        sessions.forEach((key, session) -> {
            if (this.updates.containsKey(key)) {
                return;
            }
            ClientModel clientModel = session.getClientIfNeeded(realmModel);
            Object sessionEntity = session.getEntity();
            Long lifespan = lifespanFunction.apply(realmModel, clientModel, sessionEntity);
            Long maxIdle = maxIdleFunction.apply(realmModel, clientModel, sessionEntity);
            if (lifespan == -2L || maxIdle == -2L) {
                return;
            }
            CompletableFuture future = this.cacheHolder.cache().putIfAbsentAsync(key, session, lifespan.longValue(), TimeUnit.MILLISECONDS, maxIdle.longValue(), TimeUnit.MILLISECONDS);
            stage.dependsOn(future.thenAccept(existing -> allSessions.put(key, existing == null ? session : existing)));
        });
        CompletionStages.join((CompletionStage)stage.freeze());
        allSessions.forEach((key, wrapper) -> this.updates.put(key, new SessionUpdatesList(realmModel, wrapper)));
    }
}

