/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hibernate.Incubating;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.spi.TypeConfiguration;

@Incubating
public interface TemporalJavaType<T>
extends BasicJavaType<T> {
    public static int resolveJdbcTypeCode(TemporalType requestedTemporalPrecision) {
        return switch (requestedTemporalPrecision) {
            default -> throw new IncompatibleClassChangeError();
            case TemporalType.DATE -> 91;
            case TemporalType.TIME -> 92;
            case TemporalType.TIMESTAMP -> 93;
        };
    }

    public static Class<?> resolveJavaTypeClass(TemporalType requestedTemporalPrecision) {
        return switch (requestedTemporalPrecision) {
            default -> throw new IncompatibleClassChangeError();
            case TemporalType.DATE -> Date.class;
            case TemporalType.TIME -> Time.class;
            case TemporalType.TIMESTAMP -> Timestamp.class;
        };
    }

    public TemporalType getPrecision();

    public <X> TemporalJavaType<X> resolveTypeForPrecision(TemporalType var1, TypeConfiguration var2);

    @Override
    default public boolean isTemporalType() {
        return true;
    }
}

