/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.internal.DatabaseInformationImpl;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.internal.exec.AbstractScriptSourceInput;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputAggregate;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromFile;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromReader;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromUrl;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToFile;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToUrl;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;

public class Helper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Helper.class);

    public static ScriptSourceInput interpretScriptSourceSetting(Object scriptSourceSetting, ClassLoaderService classLoaderService, String charsetName) {
        if (scriptSourceSetting instanceof Reader) {
            Reader reader = (Reader)scriptSourceSetting;
            return new ScriptSourceInputFromReader(reader);
        }
        String scriptSourceSettingString = scriptSourceSetting.toString();
        log.tracef("Attempting to resolve script source setting: %s", scriptSourceSettingString);
        String[] paths = StringHelper.splitAtCommas(scriptSourceSettingString);
        if (paths.length == 1) {
            return Helper.interpretScriptSourceSetting(scriptSourceSettingString, classLoaderService, charsetName);
        }
        AbstractScriptSourceInput[] inputs = new AbstractScriptSourceInput[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            inputs[i] = Helper.interpretScriptSourceSetting(paths[i], classLoaderService, charsetName);
        }
        return new ScriptSourceInputAggregate(inputs);
    }

    private static AbstractScriptSourceInput interpretScriptSourceSetting(String scriptSourceSettingString, ClassLoaderService classLoaderService, String charsetName) {
        log.trace("Trying as URL...");
        URL url = classLoaderService.locateResource(scriptSourceSettingString);
        return url != null ? new ScriptSourceInputFromUrl(url, charsetName) : new ScriptSourceInputFromFile(new File(scriptSourceSettingString), charsetName);
    }

    public static ScriptTargetOutput interpretScriptTargetSetting(Object scriptTargetSetting, ClassLoaderService classLoaderService, String charsetName, boolean append) {
        if (scriptTargetSetting == null) {
            return null;
        }
        if (scriptTargetSetting instanceof Writer) {
            Writer writer = (Writer)scriptTargetSetting;
            return new ScriptTargetOutputToWriter(writer);
        }
        String scriptTargetSettingString = scriptTargetSetting.toString();
        log.tracef("Attempting to resolve script source setting: %s", scriptTargetSettingString);
        log.trace("Trying as URL...");
        URL url = classLoaderService.locateResource(scriptTargetSettingString);
        return url != null ? new ScriptTargetOutputToUrl(url, charsetName) : new ScriptTargetOutputToFile(new File(scriptTargetSettingString), charsetName, append);
    }

    public static boolean interpretNamespaceHandling(Map<String, Object> configurationValues) {
        Helper.warnIfConflictingPropertiesSet(configurationValues);
        return ConfigurationHelper.getBoolean("javax.persistence.create-database-schemas", configurationValues, ConfigurationHelper.getBoolean("jakarta.persistence.create-database-schemas", configurationValues, ConfigurationHelper.getBoolean("hibernate.hbm2ddl.create_namespaces", configurationValues)));
    }

    private static void warnIfConflictingPropertiesSet(Map<String, Object> configurationValues) {
        int count = 0;
        if (configurationValues.containsKey("javax.persistence.create-database-schemas")) {
            ++count;
        }
        if (configurationValues.containsKey("jakarta.persistence.create-database-schemas")) {
            ++count;
        }
        if (configurationValues.containsKey("hibernate.hbm2ddl.create_namespaces")) {
            ++count;
        }
        if (count > 1) {
            log.multipleSchemaCreationSettingsDefined();
        }
    }

    public static boolean interpretFormattingEnabled(Map<String, Object> configurationValues) {
        return ConfigurationHelper.getBoolean("hibernate.format_sql", configurationValues);
    }

    public static DatabaseInformation buildDatabaseInformation(ServiceRegistry serviceRegistry, DdlTransactionIsolator ddlTransactionIsolator, SqlStringGenerationContext context, SchemaManagementTool tool) {
        JdbcEnvironment jdbcEnvironment = serviceRegistry.requireService(JdbcEnvironment.class);
        try {
            return new DatabaseInformationImpl(serviceRegistry, jdbcEnvironment, context, ddlTransactionIsolator, tool);
        }
        catch (SQLException e) {
            throw jdbcEnvironment.getSqlExceptionHelper().convert(e, "Unable to build DatabaseInformation");
        }
    }

    public static SqlStringGenerationContext createSqlStringGenerationContext(ExecutionOptions options, Metadata metadata) {
        Database database = metadata.getDatabase();
        return SqlStringGenerationContextImpl.fromConfigurationMap(database.getJdbcEnvironment(), database, options.getConfigurationValues());
    }

    public static void applySqlStrings(String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings != null) {
            for (String sqlString : sqlStrings) {
                Helper.applySqlString(sqlString, formatter, options, targets);
            }
        }
    }

    public static void applySqlString(String sqlString, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (!StringHelper.isEmpty(sqlString)) {
            String sqlStringFormatted = formatter.format(sqlString);
            for (GenerationTarget target : targets) {
                try {
                    target.accept(sqlStringFormatted);
                }
                catch (CommandAcceptanceException e) {
                    options.getExceptionHandler().handleException(e);
                }
            }
        }
    }

    public static void applyScript(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, Dialect dialect, ScriptSourceInput scriptInput, Formatter formatter, GenerationTarget[] targets) {
        List<String> commands = scriptInput.extract(reader -> commandExtractor.extractCommands((Reader)reader, dialect));
        for (GenerationTarget target : targets) {
            target.beforeScript(scriptInput);
        }
        for (String command : commands) {
            Helper.applySqlString(command, formatter, options, targets);
        }
    }
}

