/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.TableKeyExpressionCollector;
import org.hibernate.query.sqm.mutation.internal.temptable.ColumnReferenceCheckingSqlAstWalker;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithoutIdTableHelper;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.jboss.logging.Logger;

public class TableBasedDeleteHandler
extends AbstractMutationHandler
implements DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedDeleteHandler.class);
    private final TemporaryTable idTable;
    private final TemporaryTableStrategy temporaryTableStrategy;
    private final boolean forceDropAfterUse;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> resolvedParameterMappingModelTypes;
    private final @Nullable JdbcParameter sessionUidParameter;
    private final @Nullable CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> idTableInsert;
    private final ArrayList<JdbcOperationQueryMutation> deletes;
    private final ArrayList<JdbcOperationQueryMutation> collectionTableDeletes;

    public TableBasedDeleteHandler(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, TemporaryTable idTable, TemporaryTableStrategy temporaryTableStrategy, boolean forceDropAfterUse, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        super(sqmDelete, context.getSession().getSessionFactory());
        this.idTable = idTable;
        this.temporaryTableStrategy = temporaryTableStrategy;
        this.forceDropAfterUse = forceDropAfterUse;
        this.sessionUidAccess = sessionUidAccess;
        TemporaryTableSessionUidColumn sessionUidColumn = idTable.getSessionUidColumn();
        this.sessionUidParameter = sessionUidColumn == null ? null : new JdbcParameterImpl(sessionUidColumn.getJdbcMapping());
        MultiTableSqmMutationConverter converter = new MultiTableSqmMutationConverter(this.getEntityDescriptor(), (SqmStatement<?>)sqmDelete, (SqmRoot<?>)sqmDelete.getTarget(), domainParameterXref, context.getQueryOptions(), context.getSession().getLoadQueryInfluencers(), context.getQueryParameterBindings(), this.getSessionFactory().getSqlTranslationEngine());
        EntityPersister entityDescriptor = this.getSessionFactory().getMappingMetamodel().getEntityDescriptor(((SqmRoot)sqmDelete.getTarget()).getEntityName());
        String hierarchyRootTableName = entityDescriptor.getTableName();
        TableGroup deletingTableGroup = converter.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = deletingTableGroup.resolveTableReference(deletingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        Predicate specifiedRestriction = converter.visitWhereClause(sqmDelete.getWhereClause());
        PredicateCollector predicateCollector = new PredicateCollector(specifiedRestriction);
        entityDescriptor.applyBaseRestrictions(predicateCollector, deletingTableGroup, true, context.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, converter);
        converter.pruneTableGroupJoins();
        ColumnReferenceCheckingSqlAstWalker walker = new ColumnReferenceCheckingSqlAstWalker(hierarchyRootTableReference.getIdentificationVariable());
        if (predicateCollector.getPredicate() != null) {
            predicateCollector.getPredicate().accept(walker);
        }
        boolean needsIdTable = !walker.isAllColumnReferencesFromIdentificationVariable() || entityDescriptor != entityDescriptor.getRootEntityDescriptor();
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        this.domainParameterXref = domainParameterXref;
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, converter);
        this.resolvedParameterMappingModelTypes = converter.getSqmParameterMappingModelExpressibleResolutions();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedDeleteHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(idTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(sessionUidAccess.apply(context.getSession()))));
        }
        this.idTableInsert = !needsIdTable ? null : ExecuteWithTemporaryTableHelper.createMatchingIdsIntoIdTableInsert(converter, predicateCollector.getPredicate(), idTable, this.sessionUidParameter, jdbcParameterBindings, executionContextAdapter);
        ArrayList<JdbcOperationQueryMutation> deletes = new ArrayList<JdbcOperationQueryMutation>();
        ArrayList collectionTableDeletes = new ArrayList();
        if (needsIdTable) {
            QuerySpec idTableIdentifierSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(idTable, this.sessionUidParameter, this.getEntityDescriptor(), executionContextAdapter);
            SqmMutationStrategyHelper.visitCollectionTableDeletes(this.getEntityDescriptor(), (tableReference, attributeMapping) -> {
                ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
                QuerySpec idTableFkSubQuery = fkDescriptor.getTargetPart().isEntityIdentifierMapping() ? idTableIdentifierSubQuery : ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(idTable, fkDescriptor.getTargetPart(), this.sessionUidParameter, this.getEntityDescriptor(), executionContextAdapter);
                return new InSubQueryPredicate(MappingModelCreationHelper.buildColumnReferenceExpression(new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), fkDescriptor, null, this.getSessionFactory()), idTableFkSubQuery, false);
            }, JdbcParameterBindings.NO_BINDINGS, executionContextAdapter.getQueryOptions(), collectionTableDeletes::add);
            this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> deletes.add(this.createTableDeleteUsingIdTable(tableExpression, tableKeyColumnVisitationSupplier, idTableIdentifierSubQuery, executionContextAdapter)));
        } else {
            EntityPersister rootEntityPersister = this.getEntityDescriptor().getEntityPersister();
            String rootTableName = rootEntityPersister.getTableName();
            NamedTableReference rootTableReference = (NamedTableReference)deletingTableGroup.resolveTableReference(deletingTableGroup.getNavigablePath(), rootTableName);
            QuerySpec matchingIdSubQuerySpec = ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec(deletingTableGroup.getNavigablePath(), rootTableReference, predicateCollector.getPredicate(), rootEntityPersister, converter.getSqlExpressionResolver(), this.getSessionFactory());
            SqmMutationStrategyHelper.visitCollectionTableDeletes(this.getEntityDescriptor(), (tableReference, attributeMapping) -> {
                if (predicateCollector.getPredicate() == null) {
                    return null;
                }
                ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
                QuerySpec idSelectFkSubQuery = fkDescriptor.getTargetPart().isEntityIdentifierMapping() ? matchingIdSubQuerySpec : ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec(deletingTableGroup.getNavigablePath(), rootTableReference, predicateCollector.getPredicate(), rootEntityPersister, converter.getSqlExpressionResolver(), this.getSessionFactory());
                return new InSubQueryPredicate(MappingModelCreationHelper.buildColumnReferenceExpression(new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), fkDescriptor, null, this.getSessionFactory()), idSelectFkSubQuery, false);
            }, jdbcParameterBindings, executionContextAdapter.getQueryOptions(), collectionTableDeletes::add);
            if (rootTableReference instanceof UnionTableReference) {
                this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
                    NamedTableReference tableReference = new NamedTableReference(tableExpression, deletingTableGroup.getPrimaryTableReference().getIdentificationVariable());
                    QuerySpec idMatchingSubQuerySpec = predicateCollector.getPredicate() == null ? null : matchingIdSubQuerySpec;
                    deletes.add(this.createNonRootTableDeleteWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, converter.getSqlExpressionResolver(), deletingTableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContextAdapter));
                });
            } else {
                this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
                    if (!tableExpression.equals(rootTableName)) {
                        NamedTableReference tableReference = (NamedTableReference)deletingTableGroup.getTableReference(deletingTableGroup.getNavigablePath(), tableExpression, true);
                        QuerySpec idMatchingSubQuerySpec = predicateCollector.getPredicate() == null ? null : matchingIdSubQuerySpec;
                        deletes.add(this.createNonRootTableDeleteWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, converter.getSqlExpressionResolver(), deletingTableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContextAdapter));
                    }
                });
                deletes.add(this.createRootTableDeleteWithoutIdTable(rootTableReference, predicateCollector.getPredicate(), jdbcParameterBindings, executionContextAdapter));
            }
        }
        this.deletes = deletes;
        this.collectionTableDeletes = collectionTableDeletes;
        firstJdbcParameterBindingsConsumer.set(jdbcParameterBindings);
    }

    private JdbcOperationQueryMutation createTableDeleteUsingIdTable(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.getEntityDescriptor());
        NamedTableReference targetTable = new NamedTableReference(tableExpression, "to_delete_", true);
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(tableExpression));
            assert (!selection.isFormula());
            assert (selection.getCustomReadExpression() == null);
            assert (selection.getCustomWriteExpression() == null);
            keyColumnCollector.apply(new ColumnReference(targetTable, selection));
        });
        InSubQueryPredicate predicate = new InSubQueryPredicate(keyColumnCollector.buildKeyExpression(), idTableSubQuery, false);
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        return jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, new DeleteStatement(targetTable, predicate)).translate(JdbcParameterBindings.NO_BINDINGS, executionContext.getQueryOptions());
    }

    private JdbcOperationQueryMutation createRootTableDeleteWithoutIdTable(NamedTableReference rootTableReference, Predicate predicate, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        return jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, new DeleteStatement(rootTableReference, predicate)).translate(jdbcParameterBindings, executionContext.getQueryOptions());
    }

    private JdbcOperationQueryMutation createNonRootTableDeleteWithoutIdTable(NamedTableReference targetTableReference, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, SqlExpressionResolver sqlExpressionResolver, TableGroup rootTableGroup, QuerySpec matchingIdSubQuerySpec, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        InSubQueryPredicate tableDeletePredicate;
        assert (targetTableReference != null);
        NamedTableReference deleteTableReference = new NamedTableReference(targetTableReference.getTableExpression(), "to_delete_", true);
        if (matchingIdSubQuerySpec == null) {
            tableDeletePredicate = null;
        } else {
            ArrayList deletingTableColumnRefs = new ArrayList();
            tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
                assert (deleteTableReference.getTableReference(selection.getContainingTableExpression()) != null);
                Expression expression = sqlExpressionResolver.resolveSqlExpression(deleteTableReference, selection);
                deletingTableColumnRefs.add((ColumnReference)expression);
            });
            Expression deletingTableColumnRefsExpression = deletingTableColumnRefs.size() == 1 ? (Expression)deletingTableColumnRefs.get(0) : new SqlTuple(deletingTableColumnRefs, this.getEntityDescriptor().getIdentifierMapping());
            tableDeletePredicate = new InSubQueryPredicate(deletingTableColumnRefsExpression, matchingIdSubQuerySpec, false);
        }
        DeleteStatement sqlAstDelete = new DeleteStatement(deleteTableReference, tableDeletePredicate);
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        return jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, sqlAstDelete).translate(jdbcParameterBindings, executionContext.getQueryOptions());
    }

    @Override
    public JdbcParameterBindings createJdbcParameterBindings(DomainQueryExecutionContext context) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedDeleteHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.idTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(context.getSession()))));
        }
        return jdbcParameterBindings;
    }

    @Override
    public boolean dependsOnParameterBindings() {
        if (this.idTableInsert != null && this.idTableInsert.jdbcOperation().dependsOnParameterBindings()) {
            return true;
        }
        for (JdbcOperationQueryMutation delete : this.deletes) {
            if (!delete.dependsOnParameterBindings()) continue;
            return true;
        }
        for (JdbcOperationQueryMutation delete : this.collectionTableDeletes) {
            if (!delete.dependsOnParameterBindings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        if (this.idTableInsert != null && !this.idTableInsert.jdbcOperation().isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return false;
        }
        for (JdbcOperationQueryMutation delete : this.deletes) {
            if (delete.isCompatibleWith(jdbcParameterBindings, queryOptions)) continue;
            return false;
        }
        for (JdbcOperationQueryMutation delete : this.collectionTableDeletes) {
            if (delete.isCompatibleWith(jdbcParameterBindings, queryOptions)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext context) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table delete execution - %s", (Object)((SqmRoot)this.getSqmStatement().getTarget()).getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        if (this.idTableInsert != null) {
            ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.idTable, this.temporaryTableStrategy, (ExecutionContext)executionContext);
            try {
                int rows = ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(this.idTableInsert.jdbcOperation(), jdbcParameterBindings, (ExecutionContext)executionContext);
                JdbcParameterBindingsImpl sessionUidBindings = new JdbcParameterBindingsImpl(1);
                if (this.sessionUidParameter != null) {
                    sessionUidBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.sessionUidParameter.getExpressionType().getSingleJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(executionContext.getSession()))));
                }
                SessionFactoryImplementor factory = executionContext.getSession().getFactory();
                JdbcMutationExecutor jdbcMutationExecutor = factory.getJdbcServices().getJdbcMutationExecutor();
                for (JdbcOperationQueryMutation delete : this.collectionTableDeletes) {
                    jdbcMutationExecutor.execute(delete, sessionUidBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
                }
                for (JdbcOperationQueryMutation delete : this.deletes) {
                    jdbcMutationExecutor.execute(delete, sessionUidBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
                }
                int n = rows;
                return n;
            }
            finally {
                ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.idTable, this.sessionUidAccess, this.getAfterUseAction(), executionContext);
            }
        }
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcMutationExecutor jdbcMutationExecutor = factory.getJdbcServices().getJdbcMutationExecutor();
        for (JdbcOperationQueryMutation delete : this.collectionTableDeletes) {
            jdbcMutationExecutor.execute(delete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        }
        if (this.getEntityDescriptor() instanceof UnionSubclassEntityPersister) {
            int rows = 0;
            for (JdbcOperationQueryMutation delete : this.deletes) {
                rows += jdbcMutationExecutor.execute(delete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
            }
            return rows;
        }
        int rows = 0;
        for (JdbcOperationQueryMutation delete : this.deletes) {
            rows = jdbcMutationExecutor.execute(delete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        }
        return rows;
    }

    public @Nullable CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> getIdTableInsert() {
        return this.idTableInsert;
    }

    protected ArrayList<JdbcOperationQueryMutation> getDeletes() {
        return this.deletes;
    }

    protected ArrayList<JdbcOperationQueryMutation> getCollectionTableDeletes() {
        return this.collectionTableDeletes;
    }

    protected AfterUseAction getAfterUseAction() {
        return this.forceDropAfterUse ? AfterUseAction.DROP : this.temporaryTableStrategy.getTemporaryTableAfterUseAction();
    }

    protected TemporaryTable getIdTable() {
        return this.idTable;
    }

    protected TemporaryTableStrategy getTemporaryTableStrategy() {
        return this.temporaryTableStrategy;
    }

    protected Function<SharedSessionContractImplementor, String> getSessionUidAccess() {
        return this.sessionUidAccess;
    }

    protected @Nullable JdbcParameter getSessionUidParameter() {
        return this.sessionUidParameter;
    }
}

