/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.WrongClassException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class EntityConcreteTypeLoader {
    private final EntityMappingType entityDescriptor;
    private final SelectStatement sqlSelect;
    private final JdbcParametersList jdbcParameters;

    public EntityConcreteTypeLoader(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        JdbcParametersList.Builder builder = JdbcParametersList.newBuilder();
        this.sqlSelect = LoaderSelectBuilder.createSelect((Loadable)entityDescriptor, Collections.singletonList(entityDescriptor.getDiscriminatorMapping()), entityDescriptor.getIdentifierMapping(), null, 1, new LoadQueryInfluencers(sessionFactory), new LockOptions(), builder::add, sessionFactory);
        this.jdbcParameters = builder.build();
    }

    public EntityMappingType getConcreteType(Object id, SharedSessionContractImplementor session) {
        EntityPersister concreteType;
        SessionFactoryImplementor factory = session.getSessionFactory();
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = bindings.registerParametersForEachJdbcValue(id, this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, this.sqlSelect).translate(bindings, QueryOptions.NONE);
        List results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, bindings, new BaseExecutionContext(session), RowTransformerStandardImpl.instance(), null, ListResultsConsumer.UniqueSemantic.NONE, 1);
        if (results.isEmpty()) {
            throw new ObjectNotFoundException(this.entityDescriptor.getEntityName(), id);
        }
        assert (results.size() == 1);
        Object result = results.get(0);
        MappingMetamodelImplementor mappingMetamodel = factory.getMappingMetamodel();
        if (result instanceof Class) {
            Class concreteClass = (Class)result;
            v0 = mappingMetamodel.getEntityDescriptor(concreteClass);
        } else {
            v0 = concreteType = mappingMetamodel.getEntityDescriptor((String)result);
        }
        if (!concreteType.isTypeOrSuperType(this.entityDescriptor)) {
            throw new WrongClassException(concreteType.getEntityName(), id, this.entityDescriptor.getEntityName(), result);
        }
        return concreteType;
    }
}

