/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.Internal;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.internal.ArrayBackedBinaryStream;
import org.hibernate.engine.jdbc.internal.StreamBackedBinaryStream;
import org.hibernate.type.descriptor.java.DataHelper;

@Internal
public final class BlobProxy
implements Blob,
BlobImplementer {
    private final BinaryStream binaryStream;
    private final int markBytes;
    private boolean resetAllowed;
    private boolean needsReset;

    private BlobProxy(byte[] bytes) {
        this.binaryStream = new ArrayBackedBinaryStream(bytes);
        this.markBytes = bytes.length + 1;
        this.setStreamMark();
    }

    private BlobProxy(InputStream stream, long length) {
        this.binaryStream = new StreamBackedBinaryStream(stream, length);
        this.markBytes = (int)length + 1;
        this.setStreamMark();
    }

    private void setStreamMark() {
        InputStream inputStream = this.binaryStream.getInputStream();
        if (inputStream != null && inputStream.markSupported()) {
            inputStream.mark(this.markBytes);
            this.resetAllowed = true;
        } else {
            this.resetAllowed = false;
        }
    }

    private InputStream getStream() throws SQLException {
        return this.getUnderlyingStream().getInputStream();
    }

    @Override
    public BinaryStream getUnderlyingStream() throws SQLException {
        this.resetIfNeeded();
        return this.binaryStream;
    }

    private void resetIfNeeded() throws SQLException {
        try {
            if (this.needsReset) {
                InputStream inputStream = this.binaryStream.getInputStream();
                if (!this.resetAllowed && inputStream != null) {
                    throw new SQLException("Underlying stream does not allow reset");
                }
                if (inputStream != null) {
                    inputStream.reset();
                    this.setStreamMark();
                }
            }
        }
        catch (IOException ioe) {
            throw new SQLException("could not reset reader");
        }
        this.needsReset = true;
    }

    public static Blob generateProxy(byte[] bytes) {
        return new BlobProxy(bytes);
    }

    public static Blob generateProxy(InputStream stream, long length) {
        return new BlobProxy(stream, length);
    }

    @Override
    public long length() throws SQLException {
        return this.binaryStream.getLength();
    }

    @Override
    public byte[] getBytes(long start, int length) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Start position 1-based; must be 1 or more.");
        }
        if (length < 0) {
            throw new SQLException("Length must be great-than-or-equal to zero.");
        }
        return DataHelper.extractBytes(this.getStream(), start - 1L, length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getStream();
    }

    @Override
    public long position(byte[] pattern, long start) {
        throw BlobProxy.notSupported();
    }

    @Override
    public long position(Blob pattern, long start) {
        throw BlobProxy.notSupported();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) {
        throw BlobProxy.notSupported();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) {
        throw BlobProxy.notSupported();
    }

    @Override
    public OutputStream setBinaryStream(long pos) {
        throw BlobProxy.notSupported();
    }

    @Override
    public void truncate(long len) {
        throw BlobProxy.notSupported();
    }

    @Override
    public void free() {
        this.binaryStream.release();
    }

    @Override
    public InputStream getBinaryStream(long start, long length) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Start position 1-based; must be 1 or more.");
        }
        if (start > this.length()) {
            throw new SQLException("Start position [" + start + "] cannot exceed overall CLOB length [" + this.length() + "]");
        }
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Can't deal with Blobs larger than 'Integer.MAX_VALUE'");
        }
        if (length < 0L) {
            throw new SQLException("Length must be great-than-or-equal to zero.");
        }
        return DataHelper.subStream(this.getStream(), start - 1L, (int)length);
    }

    private static UnsupportedOperationException notSupported() {
        return new UnsupportedOperationException("Blob may not be manipulated from creating session");
    }
}

