/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ElementViaArrayArgumentReturnTypeResolver
implements FunctionReturnTypeResolver {
    public static final FunctionReturnTypeResolver DEFAULT_INSTANCE = new ElementViaArrayArgumentReturnTypeResolver(0);
    private final int arrayIndex;

    private ElementViaArrayArgumentReturnTypeResolver(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    @Override
    public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, @Nullable SqmToSqlAstConverter converter, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        BasicType basicType;
        SqmDomainType sqmDomainType;
        MappingModelExpressible<?> inferredType;
        MappingModelExpressible<?> mappingModelExpressible = inferredType = converter == null ? null : converter.resolveFunctionImpliedReturnType();
        if (inferredType != null) {
            if (inferredType instanceof ReturnableType) {
                ReturnableType returnableType = (ReturnableType)((Object)inferredType);
                return returnableType;
            }
            if (inferredType instanceof BasicValuedMapping) {
                BasicValuedMapping basicValuedMapping = (BasicValuedMapping)inferredType;
                return (ReturnableType)((Object)basicValuedMapping.getJdbcMapping());
            }
        }
        if (impliedType != null) {
            return impliedType;
        }
        SqmBindableType<?> expressible = arguments.get(this.arrayIndex).getExpressible();
        if (expressible != null && (sqmDomainType = expressible.getSqmType()) instanceof BasicPluralType) {
            BasicPluralType type = (BasicPluralType)sqmDomainType;
            basicType = type.getElementType();
        } else {
            basicType = null;
        }
        return basicType;
    }

    @Override
    public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
        return null;
    }
}

