/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CascadeType;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.annotations.spi.AttributeMarker;
import org.hibernate.models.spi.ModelsContext;

public class OneToManyJpaAnnotation
implements OneToMany,
AttributeMarker.Fetchable,
AttributeMarker.Cascadeable {
    private Class<?> targetEntity;
    private CascadeType[] cascade;
    private FetchType fetch;
    private String mappedBy;
    private boolean orphanRemoval;

    public OneToManyJpaAnnotation(ModelsContext modelContext) {
        this.targetEntity = Void.TYPE;
        this.cascade = new CascadeType[0];
        this.fetch = FetchType.LAZY;
        this.mappedBy = "";
        this.orphanRemoval = false;
    }

    public OneToManyJpaAnnotation(OneToMany annotation, ModelsContext modelContext) {
        this.targetEntity = annotation.targetEntity();
        this.cascade = annotation.cascade();
        this.fetch = annotation.fetch();
        this.mappedBy = annotation.mappedBy();
        this.orphanRemoval = annotation.orphanRemoval();
    }

    public OneToManyJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.targetEntity = (Class)attributeValues.get("targetEntity");
        this.cascade = (CascadeType[])attributeValues.get("cascade");
        this.fetch = (FetchType)attributeValues.get("fetch");
        this.mappedBy = (String)attributeValues.get("mappedBy");
        this.orphanRemoval = (Boolean)attributeValues.get("orphanRemoval");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return OneToMany.class;
    }

    public Class<?> targetEntity() {
        return this.targetEntity;
    }

    public void targetEntity(Class<?> value) {
        this.targetEntity = value;
    }

    @Override
    public CascadeType[] cascade() {
        return this.cascade;
    }

    @Override
    public void cascade(CascadeType[] value) {
        this.cascade = value;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    @Override
    public void fetch(FetchType value) {
        this.fetch = value;
    }

    public String mappedBy() {
        return this.mappedBy;
    }

    public void mappedBy(String value) {
        this.mappedBy = value;
    }

    public boolean orphanRemoval() {
        return this.orphanRemoval;
    }

    public void orphanRemoval(boolean value) {
        this.orphanRemoval = value;
    }
}

