/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license;

import liquibase.Scope;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;

public class LicenseServiceUtils {
    public static boolean isProLicenseValid() {
        LicenseServiceFactory licenseServiceFactory = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
        if (licenseServiceFactory == null) {
            return false;
        }
        LicenseService licenseService = licenseServiceFactory.getLicenseService();
        if (licenseService == null) {
            return false;
        }
        return licenseService.licenseIsValid("Liquibase Pro");
    }

    public static void checkProLicenseAndThrowException(String[] commandNames) throws CommandValidationException {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            LicenseServiceFactory licenseServiceFactory = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
            LicenseService licenseService = licenseServiceFactory.getLicenseService();
            throw new CommandValidationException(licenseService.getInvalidLicenseMessage(commandNames));
        }
    }
}

