/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractMappingConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -3181156290079915301L;
    private final Function<String, String> mapping;

    public AbstractMappingConfigSourceInterceptor(Function<String, String> mapping) {
        this.mapping = mapping != null ? mapping : Function.identity();
    }

    public AbstractMappingConfigSourceInterceptor(final Map<String, String> mappings) {
        this(new Function<String, String>(){

            @Override
            public String apply(String name) {
                return mappings.getOrDefault(name, name);
            }
        });
    }

    @Override
    public Iterator<String> iterateNames(final ConfigSourceInterceptorContext context) {
        return new Iterator<String>(){
            final Iterator<String> iterator;
            String mappedName;
            {
                this.iterator = context.iterateNames();
                this.mappedName = null;
            }

            @Override
            public boolean hasNext() {
                return this.mappedName != null || this.iterator.hasNext();
            }

            @Override
            public String next() {
                String mappedName;
                if (this.mappedName != null) {
                    String mappedName2 = this.mappedName;
                    this.mappedName = null;
                    return mappedName2;
                }
                String name = this.iterator.next();
                if (!name.equals(mappedName = AbstractMappingConfigSourceInterceptor.this.mapping.apply(name))) {
                    this.mappedName = mappedName;
                }
                return name;
            }
        };
    }

    protected Function<String, String> getMapping() {
        return this.mapping;
    }
}

