/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class AnnotationScannerFactory
implements Supplier<Iterable<AnnotationScanner>> {
    private final List<AnnotationScanner> loadedScanners;

    public AnnotationScannerFactory(ClassLoader loader) {
        ServiceLoader<AnnotationScanner> scanners = ServiceLoader.load(AnnotationScanner.class, loader);
        this.loadedScanners = StreamSupport.stream(scanners.spliterator(), false).sorted(Comparator.comparing(AnnotationScanner::getName, Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
    }

    public List<AnnotationScanner> getAnnotationScanners() {
        return new ArrayList<AnnotationScanner>(this.loadedScanners);
    }

    @Override
    public Iterable<AnnotationScanner> get() {
        return this.getAnnotationScanners();
    }
}

