/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.spi.preferences.Config;

public final class PatternUtils {
    private static final String MAGIC_STRING = "========";
    private static final CacheAccess<String, Pattern> cache = JCSCacheManager.getCache("java:pattern", Config.getPref().getInt("java.pattern.cache", 1024), 0, null);

    private PatternUtils() {
    }

    public static Pattern compile(String regex) {
        return PatternUtils.compile(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        StringBuilder sb = new StringBuilder(3 + MAGIC_STRING.length() + regex.length());
        return cache.get(sb.append(flags).append(MAGIC_STRING).append(regex).toString(), () -> Pattern.compile(regex, flags));
    }

    static {
        IElementAttributes defaultAttributes = Optional.ofNullable(cache.getDefaultElementAttributes()).orElseGet(ElementAttributes::new);
        defaultAttributes.setIdleTime(TimeUnit.HOURS.toSeconds(1L));
        cache.setDefaultElementAttributes(defaultAttributes);
    }
}

