/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public interface DisableShortcutsOnFocusGainedComponent
extends FocusListener {
    @Override
    default public void focusGained(FocusEvent e) {
        this.disableMenuActions();
        this.unregisterActionShortcuts();
    }

    @Override
    default public void focusLost(FocusEvent e) {
        this.restoreActionShortcuts();
        this.restoreMenuActions();
    }

    public List<Pair<Action, Shortcut>> getUnregisteredActionShortcuts();

    public Set<JosmAction> getDisabledMenuActions();

    default public void disableMenuActions() {
        this.getDisabledMenuActions().clear();
        for (int i = 0; i < MainApplication.getMenu().getMenuCount(); ++i) {
            JMenu menu = MainApplication.getMenu().getMenu(i);
            if (menu == null) continue;
            for (int j = 0; j < menu.getItemCount(); ++j) {
                KeyStroke ks;
                Shortcut shortcut;
                Action action;
                JMenuItem item = menu.getItem(j);
                if (item == null || !((action = item.getAction()) instanceof JosmAction) || !action.isEnabled() || (shortcut = ((JosmAction)action).getShortcut()) == null || !this.hasToBeDisabled(ks = shortcut.getKeyStroke())) continue;
                action.setEnabled(false);
                this.getDisabledMenuActions().add((JosmAction)action);
            }
        }
    }

    default public void unregisterActionShortcuts() {
        this.getUnregisteredActionShortcuts().clear();
        for (Shortcut shortcut : Shortcut.listAll()) {
            Action action;
            KeyStroke ks = shortcut.getKeyStroke();
            if (!this.hasToBeDisabled(ks) || (action = MainApplication.getRegisteredActionShortcut(shortcut)) == null) continue;
            MainApplication.unregisterActionShortcut(action, shortcut);
            this.getUnregisteredActionShortcuts().add(new Pair<Action, Shortcut>(action, shortcut));
        }
    }

    default public boolean hasToBeDisabled(KeyStroke ks) {
        if (this instanceof Component) {
            return ks != null && (ks.getModifiers() == 0 || DisableShortcutsOnFocusGainedComponent.isOnlyShift(ks.getModifiers())) && !new KeyEvent((Component)((Object)this), 401, 0L, ks.getModifiers(), ks.getKeyCode(), ks.getKeyChar()).isActionKey();
        }
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not an instanceof Component");
    }

    public static boolean isOnlyShift(int modifiers) {
        return (modifiers & 0x40) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x200) == 0 && (modifiers & 0x2000) == 0 && (modifiers & 0x100) == 0;
    }

    default public void restoreMenuActions() {
        for (JosmAction a : this.getDisabledMenuActions()) {
            a.setEnabled(true);
        }
        this.getDisabledMenuActions().clear();
    }

    default public void restoreActionShortcuts() {
        for (Pair<Action, Shortcut> p : this.getUnregisteredActionShortcuts()) {
            MainApplication.registerActionShortcut((Action)p.a, (Shortcut)p.b);
        }
        this.getUnregisteredActionShortcuts().clear();
    }
}

