/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.time.format.FormatStyle;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class VersionTableModel
extends AbstractTableModel {
    private final HistoryBrowserModel model;

    public VersionTableModel(HistoryBrowserModel model) {
        this.model = model;
    }

    @Override
    public int getRowCount() {
        if (this.model.getHistory() == null) {
            return 0;
        }
        int ret = this.model.getHistory().getNumVersions();
        if (this.model.getLatest() != null) {
            ++ret;
        }
        return ret;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                HistoryOsmPrimitive p1 = this.model.getPrimitive(row);
                if (p1 != null) {
                    return Long.toString(p1.getVersion());
                }
                return null;
            }
            case 1: {
                return this.model.isReferencePointInTime(row);
            }
            case 2: {
                return this.model.isCurrentPointInTime(row);
            }
            case 3: {
                HistoryOsmPrimitive p3 = this.model.getPrimitive(row);
                if (p3 != null && p3.getInstant() != null) {
                    return DateUtils.getDateTimeFormatter(FormatStyle.SHORT, FormatStyle.SHORT).format(p3.getInstant());
                }
                return null;
            }
            case 4: {
                User user;
                HistoryOsmPrimitive p4 = this.model.getPrimitive(row);
                if (p4 != null && (user = p4.getUser()) != null) {
                    return user.getName();
                }
                return null;
            }
            case 5: {
                Changeset cs;
                HistoryOsmPrimitive p5 = this.model.getPrimitive(row);
                if (p5 != null && (cs = p5.getChangeset()) != null) {
                    return cs.get("created_by");
                }
                return null;
            }
        }
        return null;
    }

    public Color getVersionColor(int row) {
        return this.model.getVersionColor(row);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (!((Boolean)aValue).booleanValue()) {
            return;
        }
        try {
            switch (column) {
                case 1: {
                    this.model.setReferencePointInTime(row);
                    break;
                }
                case 2: {
                    this.model.setCurrentPointInTime(row);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IllegalArgumentException e) {
            Logging.error(e);
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column >= 1 && column <= 2;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }
}

