/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public RelationMemberListTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void renderIcon(RelationMemberData member) {
        if (member == null) {
            this.setIcon(null);
        } else {
            this.setIcon(ImageProvider.get(member.getMemberType()));
        }
    }

    protected void renderIndex(DiffTableModel model, int row) {
        int rowNumber = model.getRowNumber(row);
        this.setText(rowNumber > 0 ? Integer.toString(rowNumber) : "");
        this.setToolTipText(null);
        this.setHorizontalAlignment(0);
        this.renderIcon(null);
    }

    protected void renderRole(TwoColumnDiff.Item diffItem) {
        RelationMemberData member = (RelationMemberData)diffItem.value;
        String text = member == null ? "" : member.getRole();
        this.setText(text);
        this.setToolTipText(text);
        this.setHorizontalAlignment(10);
        this.renderIcon(null);
    }

    protected void renderPrimitive(TwoColumnDiff.Item diffItem) {
        String text = "";
        RelationMemberData member = (RelationMemberData)diffItem.value;
        if (member != null) {
            switch (member.getMemberType()) {
                case NODE: {
                    text = I18n.tr("Node {0}", member.getMemberId());
                    break;
                }
                case WAY: {
                    text = I18n.tr("Way {0}", member.getMemberId());
                    break;
                }
                case RELATION: {
                    text = I18n.tr("Relation {0}", member.getMemberId());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setHorizontalAlignment(10);
        this.renderIcon((RelationMemberData)diffItem.value);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        TwoColumnDiff.Item member = (TwoColumnDiff.Item)value;
        TwoColumnDiff.Item.DiffItemType type = member.state;
        switch (column) {
            case 0: {
                type = TwoColumnDiff.Item.DiffItemType.EMPTY;
                this.renderIndex((DiffTableModel)table.getModel(), row);
                break;
            }
            case 1: {
                this.renderRole(member);
                break;
            }
            case 2: {
                this.renderPrimitive(member);
                break;
            }
        }
        GuiHelper.setBackgroundReadable(this, type.getColor(isSelected, hasFocus));
        return this;
    }
}

