/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DownloadSelectedIncompleteMembersAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    public DownloadSelectedIncompleteMembersAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, IRelationEditorUpdateOn.MEMBER_TABLE_CHANGE, IRelationEditorUpdateOn.MEMBER_TABLE_SELECTION);
        this.putValue("ShortDescription", I18n.tr("Download selected incomplete members", new Object[0]));
        new ImageProvider("dialogs/relation", "downloadincompleteselected").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Download members", new Object[0]));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        MainApplication.worker.submit(new DownloadRelationMemberTask(this.getEditor().getRelation(), this.getMemberTableModel().getSelectedIncompleteMemberPrimitives(), this.getLayer(), (Dialog)((Object)this.getEditor())));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getMemberTableModel().hasIncompleteSelectedMembers() && this.canDownload());
    }
}

