/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Color;
import javax.swing.BorderFactory;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.changeset.query.RestrictionPanel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.BoundingBoxSelectionPanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.I18n;

public class BBoxRestrictionPanel
extends BoundingBoxSelectionPanel
implements RestrictionPanel {
    public BBoxRestrictionPanel() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
    }

    @Override
    public boolean isValidChangesetQuery() {
        return this.getBoundingBox() != null;
    }

    @Override
    public void fillInQuery(ChangesetQuery query) {
        if (!this.isValidChangesetQuery()) {
            throw new IllegalStateException(I18n.tr("Cannot restrict the changeset query to a specific bounding box. The input is invalid.", new Object[0]));
        }
        query.inBbox(this.getBoundingBox());
    }

    @Override
    public void displayMessageIfInvalid() {
        if (this.isValidChangesetQuery()) {
            return;
        }
        HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>Please enter valid longitude/latitude values to restrict<br>the changeset query to a specific bounding box.</html>", new Object[0]), I18n.tr("Invalid bounding box", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidBoundingBox"));
    }
}

