/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.Objects;
import org.openstreetmap.josm.data.gpx.GpxImageDatumSettings;
import org.openstreetmap.josm.data.gpx.GpxImageDirectionPositionSettings;
import org.openstreetmap.josm.data.gpx.TimeSource;

public class GpxImageCorrelationSettings {
    private final long offset;
    private final boolean forceTags;
    private final TimeSource imgTimeSource;
    private final GpxImageDirectionPositionSettings directionPositionSettings;
    private final GpxImageDatumSettings datumSettings;

    public GpxImageCorrelationSettings(long offset, boolean forceTags) {
        this(offset, forceTags, TimeSource.EXIFCAMTIME, new GpxImageDirectionPositionSettings(false, 0.0, false, 0.0, 0.0, 0.0), new GpxImageDatumSettings(false, null));
    }

    public GpxImageCorrelationSettings(long offset, boolean forceTags, TimeSource imgTimeSource, GpxImageDirectionPositionSettings directionPositionSettings) {
        this(offset, forceTags, imgTimeSource, directionPositionSettings, new GpxImageDatumSettings(false, null));
    }

    public GpxImageCorrelationSettings(long offset, boolean forceTags, TimeSource imgTimeSource, GpxImageDirectionPositionSettings directionPositionSettings, GpxImageDatumSettings datumSettings) {
        this.offset = offset;
        this.forceTags = forceTags;
        this.imgTimeSource = imgTimeSource;
        this.directionPositionSettings = Objects.requireNonNull(directionPositionSettings);
        this.datumSettings = Objects.requireNonNull(datumSettings);
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isForceTags() {
        return this.forceTags;
    }

    public TimeSource getImgTimeSource() {
        return this.imgTimeSource;
    }

    public GpxImageDirectionPositionSettings getDirectionPositionSettings() {
        return this.directionPositionSettings;
    }

    public GpxImageDatumSettings getDatumSettings() {
        return this.datumSettings;
    }

    public String toString() {
        return "[offset=" + this.offset + ", forceTags=" + this.forceTags + ", clock source=" + String.valueOf((Object)this.imgTimeSource) + ", directionPositionSettings=" + String.valueOf(this.directionPositionSettings) + ", datumSettings=" + String.valueOf(this.datumSettings) + "]";
    }
}

