/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.tiff;

import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.RandomAccessFileReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifTiffHandler;
import com.drew.metadata.file.FileSystemMetadataReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class TiffMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws IOException, TiffProcessingException {
        Metadata metadata;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            metadata = TiffMetadataReader.readMetadata(new RandomAccessFileReader(randomAccessFile));
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws IOException, TiffProcessingException {
        return TiffMetadataReader.readMetadata(new RandomAccessStreamReader(inputStream));
    }

    @NotNull
    public static Metadata readMetadata(@NotNull RandomAccessReader reader) throws IOException, TiffProcessingException {
        Metadata metadata = new Metadata();
        ExifTiffHandler handler = new ExifTiffHandler(metadata, null, 0);
        new TiffReader().processTiff(reader, handler, 0);
        return metadata;
    }
}

