/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Composite;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java2d.Surface;

public class ACimages
extends Surface {
    private static final String[] s = new String[]{"box", "fight", "magnify", "boxwave", "globe", "snooze", "tip", "thumbsup", "dukeplug"};
    private static Image[] imgs = new Image[s.length];
    private static Color[] colors = new Color[]{Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW, Color.LIGHT_GRAY};

    public ACimages() {
        this.setBackground(Color.WHITE);
        for (int i = 0; i < imgs.length; ++i) {
            ACimages.imgs[i] = this.getImage(s[i] + ".png");
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        float alpha = 0.0f;
        int iw = w / 3;
        int ih = (h - 45) / 3;
        float xx = 0.0f;
        float yy = 15.0f;
        for (int i = 0; i < imgs.length; ++i) {
            xx = i % 3 == 0 ? 0.0f : xx + (float)(w / 3);
            switch (i) {
                case 3: {
                    yy = h / 3 + 15;
                    break;
                }
                case 6: {
                    yy = h / 3 * 2 + 15;
                }
            }
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setColor(Color.BLACK);
            AlphaComposite ac = AlphaComposite.SrcOver.derive(alpha += 0.1f);
            String str = "a=" + Float.toString(alpha).substring(0, 3);
            new TextLayout(str, g2.getFont(), g2.getFontRenderContext()).draw(g2, xx + 3.0f, yy - 2.0f);
            RectangularShape shape = null;
            switch (i % 3) {
                case 0: {
                    shape = new Ellipse2D.Float(xx, yy, iw, ih);
                    break;
                }
                case 1: {
                    shape = new RoundRectangle2D.Float(xx, yy, iw, ih, 25.0f, 25.0f);
                    break;
                }
                case 2: {
                    shape = new Rectangle2D.Float(xx, yy, iw, ih);
                }
            }
            g2.setColor(colors[i]);
            g2.setComposite(ac);
            g2.fill(shape);
            g2.drawImage(imgs[i], (int)xx, (int)yy, iw, ih, null);
        }
    }

    public static void main(String[] s) {
        ACimages.createDemoFrame(new ACimages());
    }
}

