/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreateGistService;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Condition<@Nullable VirtualFile> FILE_WITH_CONTENT = f -> f != null && !f.getFileType().isBinary();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GithubCreateGistAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isDirectory;
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GHAccountManager accountManager = (GHAccountManager)((Object)ApplicationManager.getApplication().getService(GHAccountManager.class));
        GHHostedRepositoriesManager hostedRepositoriesManager = (GHHostedRepositoriesManager)project.getService(GHHostedRepositoriesManager.class);
        if (((Set)hostedRepositoriesManager.getKnownRepositoriesState().getValue()).isEmpty() && ((Set)accountManager.getAccountsState().getValue()).isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        boolean hasFilesWithContent = FILE_WITH_CONTENT.value((Object)file) || files != null && ContainerUtil.exists((Object[])files, FILE_WITH_CONTENT);
        boolean isTerminal = editor != null && editor.isViewer();
        boolean bl = isDirectory = file != null && file.isDirectory();
        if (!(isTerminal || isDirectory || hasFilesWithContent && (editor == null || editor.getDocument().getTextLength() != 0))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (PlatformUtils.isDataSpell()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
        if (files != null) {
            for (VirtualFile f : files) {
                GithubCreateGistAction.collectFilesRecursively(f, allFiles);
            }
        }
        GithubCreateGistService service = (GithubCreateGistService)project.getService(GithubCreateGistService.class);
        service.createGistAction(editor, (VirtualFile)(FILE_WITH_CONTENT.value((Object)file) ? file : null), GithubCreateGistAction.filterFilesWithContent(allFiles.toArray(VirtualFile.EMPTY_ARRAY)));
    }

    private static void collectFilesRecursively(VirtualFile file, List<VirtualFile> collection) {
        if (file.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = file.getChildren()) {
                GithubCreateGistAction.collectFilesRecursively(child, collection);
            }
        } else if (FILE_WITH_CONTENT.value((Object)file)) {
            collection.add(file);
        }
    }

    private static VirtualFile @Nullable [] filterFilesWithContent(@Nullable @Nullable VirtualFile @Nullable [] files) {
        if (files == null) {
            return null;
        }
        return ContainerUtil.filter((Object[])files, FILE_WITH_CONTENT).toArray(VirtualFile.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

