/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.plaf.StatusBarUI;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class BasicStatusBarUI
extends StatusBarUI {
    public static final String AUTO_ADD_SEPARATOR = new StringBuffer("auto-add-separator").toString();
    private static Insets TEMP_INSETS;
    protected JXStatusBar statusBar;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;

    public static ComponentUI createUI(JComponent c) {
        return new BasicStatusBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        assert (c instanceof JXStatusBar);
        this.statusBar = (JXStatusBar)c;
        this.installDefaults(this.statusBar);
        this.installListeners(this.statusBar);
        LayoutManager m = this.statusBar.getLayout();
        if (m == null || m instanceof UIResource) {
            this.statusBar.setLayout(this.createLayout());
        }
    }

    protected void installDefaults(JXStatusBar sb) {
        Border b = this.statusBar.getBorder();
        if (b == null || b instanceof UIResource) {
            this.statusBar.setBorder(this.createBorder());
        }
        LookAndFeel.installProperty(sb, "opaque", Boolean.TRUE);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected void installListeners(JXStatusBar sb) {
        this.mouseListener = this.createMouseListener();
        if (this.mouseListener != null) {
            this.statusBar.addMouseListener(this.mouseListener);
        }
        if ((this.mouseMotionListener = this.createMouseMotionListener()) != null) {
            this.statusBar.addMouseMotionListener(this.mouseMotionListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.statusBar.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        assert (c instanceof JXStatusBar);
        this.uninstallDefaults(this.statusBar);
        this.uninstallListeners(this.statusBar);
        if (this.statusBar.getLayout() instanceof UIResource) {
            this.statusBar.setLayout(null);
        }
    }

    protected void uninstallDefaults(JXStatusBar sb) {
        if (sb.getBorder() instanceof UIResource) {
            sb.setBorder(null);
        }
    }

    protected void uninstallListeners(JXStatusBar sb) {
        if (this.mouseListener != null) {
            this.statusBar.removeMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener != null) {
            this.statusBar.removeMouseMotionListener(this.mouseMotionListener);
        }
        if (this.propertyChangeListener != null) {
            this.statusBar.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.statusBar.isOpaque()) {
            Graphics2D g2 = (Graphics2D)g;
            this.paintBackground(g2, this.statusBar);
        }
        if (this.includeSeparators()) {
            TEMP_INSETS = this.getSeparatorInsets(TEMP_INSETS);
            for (int i2 = 0; i2 < this.statusBar.getComponentCount() - 1; ++i2) {
                Component comp = this.statusBar.getComponent(i2);
                int x = comp.getX() + comp.getWidth() + BasicStatusBarUI.TEMP_INSETS.left;
                int y = BasicStatusBarUI.TEMP_INSETS.top;
                int w = this.getSeparatorWidth() - BasicStatusBarUI.TEMP_INSETS.left - BasicStatusBarUI.TEMP_INSETS.right;
                int h = c.getHeight() - BasicStatusBarUI.TEMP_INSETS.top - BasicStatusBarUI.TEMP_INSETS.bottom;
                this.paintSeparator((Graphics2D)g, this.statusBar, x, y, w, h);
            }
        }
    }

    protected void paintBackground(Graphics2D g, JXStatusBar bar) {
        if (bar.isOpaque()) {
            g.setColor(bar.getBackground());
            g.fillRect(0, 0, bar.getWidth(), bar.getHeight());
        }
    }

    protected void paintSeparator(Graphics2D g, JXStatusBar bar, int x, int y, int w, int h) {
        Color fg = UIManagerExt.getSafeColor("Separator.foreground", Color.BLACK);
        Color bg = UIManagerExt.getSafeColor("Separator.background", Color.WHITE);
        g.setColor(fg);
        g.drawLine(x += w / 2, y, x, h);
        g.setColor(bg);
        g.drawLine(x + 1, y, x + 1, h);
    }

    protected Insets getSeparatorInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 4;
        insets.left = 4;
        insets.bottom = 2;
        insets.right = 4;
        return insets;
    }

    protected int getSeparatorWidth() {
        return 10;
    }

    protected boolean includeSeparators() {
        Boolean b = (Boolean)this.statusBar.getClientProperty(AUTO_ADD_SEPARATOR);
        return b == null || b != false;
    }

    protected BorderUIResource createBorder() {
        return new BorderUIResource(BorderFactory.createEmptyBorder(4, 5, 4, 22));
    }

    protected LayoutManager createLayout() {
        return new LayoutManager2(){
            private Map<Component, JXStatusBar.Constraint> constraints = new HashMap<Component, JXStatusBar.Constraint>();

            @Override
            public void addLayoutComponent(String name, Component comp) {
                this.addLayoutComponent(comp, null);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
                this.constraints.remove(comp);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public Dimension maximumLayoutSize(Container target) {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }

            @Override
            public float getLayoutAlignmentX(Container target) {
                return 0.5f;
            }

            @Override
            public float getLayoutAlignmentY(Container target) {
                return 0.5f;
            }

            @Override
            public void invalidateLayout(Container target) {
            }

            @Override
            public void addLayoutComponent(Component comp, Object constraint) {
                if (constraint instanceof Insets) {
                    constraint = new JXStatusBar.Constraint((Insets)constraint);
                } else if (constraint instanceof JXStatusBar.Constraint.ResizeBehavior) {
                    constraint = new JXStatusBar.Constraint((JXStatusBar.Constraint.ResizeBehavior)((Object)constraint));
                }
                this.constraints.put(comp, (JXStatusBar.Constraint)constraint);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Dimension prefSize = new Dimension();
                int count = 0;
                for (Component comp : this.constraints.keySet()) {
                    JXStatusBar.Constraint c = this.constraints.get(comp);
                    Dimension d = comp.getPreferredSize();
                    int prefWidth = 0;
                    if (c != null) {
                        Insets i2 = c.getInsets();
                        d.width += i2.left + i2.right;
                        d.height += i2.top + i2.bottom;
                        prefWidth = c.getFixedWidth();
                    }
                    prefSize.height = Math.max(prefSize.height, d.height);
                    prefSize.width += Math.max(d.width, prefWidth);
                    if (!BasicStatusBarUI.this.includeSeparators() || this.constraints.size() >= ++count) continue;
                    prefSize.width += BasicStatusBarUI.this.getSeparatorWidth();
                }
                Insets insets = parent.getInsets();
                prefSize.height += insets.top + insets.bottom;
                prefSize.width += insets.left + insets.right;
                return prefSize;
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets parentInsets = parent.getInsets();
                int availableWidth = parent.getWidth() - parentInsets.left - parentInsets.right;
                if (BasicStatusBarUI.this.includeSeparators()) {
                    availableWidth -= (parent.getComponentCount() - 1) * BasicStatusBarUI.this.getSeparatorWidth();
                }
                int[] preferredWidths = new int[parent.getComponentCount()];
                int sumPreferredWidths = 0;
                for (int i2 = 0; i2 < preferredWidths.length; ++i2) {
                    preferredWidths[i2] = this.getPreferredWidth(parent.getComponent(i2));
                    sumPreferredWidths += preferredWidths[i2];
                }
                if (availableWidth > sumPreferredWidths) {
                    int numFilledComponents = 0;
                    for (Component comp : parent.getComponents()) {
                        JXStatusBar.Constraint c = this.constraints.get(comp);
                        if (c == null || c.getResizeBehavior() != JXStatusBar.Constraint.ResizeBehavior.FILL) continue;
                        ++numFilledComponents;
                    }
                    if (numFilledComponents > 0) {
                        double weight = 1.0 / (double)numFilledComponents;
                        int share = (int)((double)(availableWidth -= sumPreferredWidths) * weight);
                        int remaining = numFilledComponents;
                        for (int i3 = 0; i3 < parent.getComponentCount(); ++i3) {
                            Component comp = parent.getComponent(i3);
                            JXStatusBar.Constraint c = this.constraints.get(comp);
                            if (c == null || c.getResizeBehavior() != JXStatusBar.Constraint.ResizeBehavior.FILL) continue;
                            if (remaining > 1) {
                                int n = i3;
                                preferredWidths[n] = preferredWidths[n] + share;
                                availableWidth -= share;
                            } else {
                                int n = i3;
                                preferredWidths[n] = preferredWidths[n] + availableWidth;
                            }
                            --remaining;
                        }
                    }
                }
                int nextX = parentInsets.left;
                int height = parent.getHeight() - parentInsets.top - parentInsets.bottom;
                for (int i4 = 0; i4 < parent.getComponentCount(); ++i4) {
                    Component comp = parent.getComponent(i4);
                    JXStatusBar.Constraint c = this.constraints.get(comp);
                    Insets insets = c == null ? new Insets(0, 0, 0, 0) : c.getInsets();
                    int width = preferredWidths[i4] - (insets.left + insets.right);
                    int x = nextX + insets.left;
                    int y = parentInsets.top + insets.top;
                    comp.setSize(width, height);
                    comp.setLocation(x, y);
                    nextX = x + width + insets.right;
                    if (!BasicStatusBarUI.this.includeSeparators() || i4 >= parent.getComponentCount() - 1) continue;
                    nextX += BasicStatusBarUI.this.getSeparatorWidth();
                }
            }

            private int getPreferredWidth(Component comp) {
                JXStatusBar.Constraint c = this.constraints.get(comp);
                if (c == null) {
                    return comp.getPreferredSize().width;
                }
                Insets insets = c.getInsets();
                assert (insets != null);
                if (c.getFixedWidth() <= 0) {
                    return comp.getPreferredSize().width + insets.left + insets.right;
                }
                return c.getFixedWidth() + insets.left + insets.right;
            }
        };
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private Window window;
        private int handleBoundary;
        private boolean validPress;
        private Point startingPoint;

        private Handler() {
            this.window = SwingUtilities.getWindowAncestor(BasicStatusBarUI.this.statusBar);
            this.handleBoundary = this.getHandleBoundary();
            this.validPress = false;
        }

        private int getHandleBoundary() {
            Border border = BasicStatusBarUI.this.statusBar.getBorder();
            if (border == null || !BasicStatusBarUI.this.statusBar.isResizeHandleEnabled()) {
                return 0;
            }
            if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                return border.getBorderInsets((Component)BasicStatusBarUI.this.statusBar).right;
            }
            return border.getBorderInsets((Component)BasicStatusBarUI.this.statusBar).left;
        }

        private boolean isHandleAreaPoint(Point point) {
            if (this.window == null || this.window.isMaximumSizeSet()) {
                return false;
            }
            if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                return point.x >= BasicStatusBarUI.this.statusBar.getWidth() - this.handleBoundary;
            }
            return point.x <= this.handleBoundary;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            if (this.isHandleAreaPoint(e2.getPoint())) {
                if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                    this.window.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    this.window.setCursor(Cursor.getPredefinedCursor(4));
                }
            } else {
                this.window.setCursor(null);
            }
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            if (!this.validPress) {
                this.window.setCursor(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.validPress = SwingUtilities.isLeftMouseButton(e2) && this.isHandleAreaPoint(e2.getPoint());
            this.startingPoint = e2.getPoint();
            SwingUtilities.convertPointToScreen(this.startingPoint, BasicStatusBarUI.this.statusBar);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.validPress = !SwingUtilities.isLeftMouseButton(e2);
            this.window.validate();
            this.window.setCursor(null);
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (this.validPress) {
                Rectangle wb = this.window.getBounds();
                Point p = e2.getPoint();
                SwingUtilities.convertPointToScreen(p, BasicStatusBarUI.this.statusBar);
                wb.height += p.y - this.startingPoint.y;
                if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                    wb.width += p.x - this.startingPoint.x;
                } else {
                    wb.x += p.x - this.startingPoint.x;
                    wb.width += this.startingPoint.x - p.x;
                }
                this.window.setBounds(wb);
                this.window.validate();
                this.startingPoint = p;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (this.isHandleAreaPoint(e2.getPoint())) {
                if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                    this.window.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    this.window.setCursor(Cursor.getPredefinedCursor(4));
                }
            } else {
                this.window.setCursor(null);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ancestor".equals(evt.getPropertyName())) {
                this.window = SwingUtilities.getWindowAncestor(BasicStatusBarUI.this.statusBar);
                boolean useResizeHandle = BasicStatusBarUI.this.statusBar.getParent() != null && BasicStatusBarUI.this.statusBar.getRootPane() != null && (BasicStatusBarUI.this.statusBar.getParent() == BasicStatusBarUI.this.statusBar.getRootPane() || BasicStatusBarUI.this.statusBar.getParent() == BasicStatusBarUI.this.statusBar.getRootPane().getContentPane());
                BasicStatusBarUI.this.statusBar.setResizeHandleEnabled(useResizeHandle);
            } else if ("border".equals(evt.getPropertyName())) {
                this.handleBoundary = this.getHandleBoundary();
            } else if ("componentOrientation".equals(evt.getPropertyName())) {
                this.handleBoundary = this.getHandleBoundary();
            } else if ("resizeHandleEnabled".equals(evt.getPropertyName())) {
                this.handleBoundary = this.getHandleBoundary();
            }
        }
    }
}

