/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.labels;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.psi.MarkdownRecursiveElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkLabel;
import org.intellij.plugins.markdown.model.psi.MarkdownPsiSymbolReferenceBase;
import org.intellij.plugins.markdown.model.psi.labels.LinkLabelSymbol;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbolReference;", "Lorg/intellij/plugins/markdown/model/psi/MarkdownPsiSymbolReferenceBase;", "Lcom/intellij/model/psi/PsiCompletableReference;", "element", "Lcom/intellij/psi/PsiElement;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "text", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "resolveReference", "", "Lcom/intellij/model/Symbol;", "getCompletionVariants", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Companion", "intellij.markdown.model"})
public final class LinkLabelSymbolReference
extends MarkdownPsiSymbolReferenceBase
implements PsiCompletableReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;

    public LinkLabelSymbolReference(@NotNull PsiElement element2, @NotNull TextRange rangeInElement, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(element2, rangeInElement);
        this.text = text2;
    }

    @NotNull
    public Collection<Symbol> resolveReference() {
        PsiFile file = this.getElement().getContainingFile();
        Intrinsics.checkNotNull((Object)file);
        Sequence declarations = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)LinkLabelSymbolReference.Companion.collectLinkLabels(file)), LinkLabelSymbolReference::resolveReference$lambda$0);
        Sequence matchingDeclarations = SequencesKt.filter((Sequence)declarations, arg_0 -> LinkLabelSymbolReference.resolveReference$lambda$1(this, arg_0));
        Sequence symbols = SequencesKt.mapNotNull((Sequence)matchingDeclarations, LinkLabelSymbolReference::resolveReference$lambda$2);
        return SequencesKt.toList((Sequence)symbols);
    }

    @NotNull
    public Collection<LookupElement> getCompletionVariants() {
        PsiFile file = this.getElement().getContainingFile();
        Intrinsics.checkNotNull((Object)file);
        Sequence labels = CollectionsKt.asSequence((Iterable)LinkLabelSymbolReference.Companion.collectLinkLabels(file));
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)labels, LinkLabelSymbolReference::getCompletionVariants$lambda$0));
    }

    private static final boolean resolveReference$lambda$0(MarkdownLinkLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LinkLabelSymbol.Companion.isDeclaration(it);
    }

    private static final boolean resolveReference$lambda$1(LinkLabelSymbolReference this$0, MarkdownLinkLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getText(), (Object)this$0.text);
    }

    private static final LinkLabelSymbol resolveReference$lambda$2(MarkdownLinkLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Pointer<LinkLabelSymbol> pointer = LinkLabelSymbol.Companion.createPointer(it);
        return pointer != null ? (LinkLabelSymbol)pointer.dereference() : null;
    }

    private static final LookupElementBuilder getCompletionVariants$lambda$0(MarkdownLinkLabel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LookupElementBuilder.create((Object)it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbolReference$Companion;", "", "<init>", "()V", "collectLinkLabels", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkLabel;", "Lcom/intellij/psi/PsiFile;", "intellij.markdown.model"})
    public static final class Companion {
        private Companion() {
        }

        private final List<MarkdownLinkLabel> collectLinkLabels(PsiFile $this$collectLinkLabels) {
            ArrayList<MarkdownLinkLabel> elements2 = new ArrayList<MarkdownLinkLabel>();
            MarkdownRecursiveElementVisitor visitor2 = new MarkdownRecursiveElementVisitor(elements2){
                final /* synthetic */ ArrayList<MarkdownLinkLabel> $elements;
                {
                    this.$elements = $elements;
                }

                public void visitElement(PsiElement element2) {
                    Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                    if (element2 instanceof MarkdownLinkLabel) {
                        this.$elements.add((MarkdownLinkLabel)element2);
                    }
                    super.visitElement(element2);
                }
            };
            $this$collectLinkLabels.accept((PsiElementVisitor)visitor2);
            return elements2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

