/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import org.jvnet.winp.Native;

public class ExitWindows {
    private static final int EWX_FORCE = 4;
    private static final int EWX_LOGOFF = 0;
    private static final int EWX_POWEROFF = 8;
    private static final int EWX_REBOOT = 2;
    private static final int EWX_FORCEIFHUNG = 10;

    private ExitWindows() {
    }

    public static void logOff(Flag f) {
        ExitWindows.exit(0, f);
    }

    public static void powerOff(Flag f) {
        ExitWindows.exit(8, f);
    }

    public static void reboot(Flag f) {
        ExitWindows.exit(2, f);
    }

    private static void exit(int ewxCode, Flag f) {
        Native.exitWindowsEx(ewxCode | f.value, 0);
    }

    public static enum Flag {
        NONE(0),
        FORCE(4),
        FORCEIFHUNG(10);

        private final int value;

        private Flag(int value) {
            this.value = value;
        }
    }
}

