/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.Promise;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class PoisonTrackCounter {
    private final DataflowVariable<Boolean> termination = new DataflowVariable();
    private final AtomicInteger counter;

    PoisonTrackCounter(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("A counting poison pill can only start with a positive number");
        }
        this.counter = new AtomicInteger(count);
    }

    public void join() throws InterruptedException {
        this.termination.join();
    }

    public void join(long timeout, TimeUnit unit) throws InterruptedException {
        this.termination.join(timeout, unit);
    }

    public Promise<Boolean> getTermination() {
        return this.termination;
    }

    void countDown() {
        int currentValue = this.counter.decrementAndGet();
        if (currentValue == 0) {
            this.termination.bind(true);
        }
    }
}

