/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import org.codehaus.groovy.runtime.ArrayGroovyMethods;

public final class CurriedClosure<V>
extends Closure<V> {
    private static final long serialVersionUID = 2077643745780234126L;
    private final Object[] curriedArguments;
    private final int minParamsExpected;
    private int index;
    private Class<?> varargType;

    public CurriedClosure(int index, Closure<V> uncurriedClosure, Object ... arguments) {
        super(uncurriedClosure.clone());
        this.index = index;
        this.curriedArguments = arguments;
        int maxLen = uncurriedClosure.getMaximumNumberOfParameters();
        this.maximumNumberOfParameters = maxLen - arguments.length;
        Class<?>[] parameterTypes = uncurriedClosure.getParameterTypes();
        if (parameterTypes.length > 0 && ArrayGroovyMethods.last(parameterTypes).isArray()) {
            this.varargType = ArrayGroovyMethods.last(parameterTypes);
        }
        if (this.isVararg()) {
            this.minParamsExpected = 0;
        } else {
            if (index < 0) {
                this.index += maxLen;
                this.minParamsExpected = 0;
            } else {
                this.minParamsExpected = index + arguments.length;
            }
            if (this.maximumNumberOfParameters < 0) {
                throw new IllegalArgumentException("Can't curry " + arguments.length + " arguments for a closure with " + maxLen + " parameters.");
            }
            if (index < 0) {
                int lower = -maxLen;
                int upper = -arguments.length;
                if (index < lower || index > upper) {
                    throw new IllegalArgumentException("To curry " + arguments.length + " argument(s) expect index range " + lower + ".." + upper + " but found " + index);
                }
            } else if (index > this.maximumNumberOfParameters) {
                throw new IllegalArgumentException("To curry " + arguments.length + " argument(s) expect index range 0.." + this.maximumNumberOfParameters + " but found " + index);
            }
        }
    }

    public CurriedClosure(Closure<V> uncurriedClosure, Object ... arguments) {
        this(0, uncurriedClosure, arguments);
    }

    public Object[] getUncurriedArguments(Object ... arguments) {
        if (this.isVararg()) {
            int normalizedIndex;
            int n = normalizedIndex = this.index < 0 ? this.index + arguments.length + this.curriedArguments.length : this.index;
            if (normalizedIndex < 0 || normalizedIndex > arguments.length) {
                throw new IllegalArgumentException("When currying expected index range between " + (-arguments.length - this.curriedArguments.length) + ".." + (arguments.length + this.curriedArguments.length) + " but found " + this.index);
            }
            return this.getArguments(normalizedIndex, arguments);
        }
        if (this.curriedArguments.length + arguments.length < this.minParamsExpected) {
            throw new IllegalArgumentException("When currying expected at least " + this.index + " argument(s) to be supplied before known curried arguments but found " + arguments.length);
        }
        int newIndex = Math.min(this.index, this.curriedArguments.length + arguments.length - 1);
        newIndex = Math.min(newIndex, arguments.length);
        return this.getArguments(newIndex, arguments);
    }

    private Object[] getArguments(int index, Object[] arguments) {
        Object[] newArguments = new Object[this.curriedArguments.length + arguments.length];
        System.arraycopy(arguments, 0, newArguments, 0, index);
        System.arraycopy(this.curriedArguments, 0, newArguments, index, this.curriedArguments.length);
        if (arguments.length - index > 0) {
            System.arraycopy(arguments, index, newArguments, this.curriedArguments.length + index, arguments.length - index);
        }
        return newArguments;
    }

    @Override
    public void setDelegate(Object delegate) {
        ((Closure)this.getOwner()).setDelegate(delegate);
    }

    @Override
    public Object getDelegate() {
        return ((Closure)this.getOwner()).getDelegate();
    }

    @Override
    public Closure<V> getOwner() {
        return (Closure)super.getOwner();
    }

    @Override
    public void setResolveStrategy(int resolveStrategy) {
        ((Closure)this.getOwner()).setResolveStrategy(resolveStrategy);
    }

    @Override
    public int getResolveStrategy() {
        return ((Closure)this.getOwner()).getResolveStrategy();
    }

    @Override
    public Object clone() {
        Closure uncurriedClosure = (Closure)((Closure)this.getOwner()).clone();
        return new CurriedClosure<V>(this.index, uncurriedClosure, this.curriedArguments);
    }

    @Override
    public Class[] getParameterTypes() {
        Class<?>[] oldParams = ((Closure)this.getOwner()).getParameterTypes();
        int extraParams = 0;
        int gobbledParams = this.curriedArguments.length;
        if (this.isVararg()) {
            int numNonVarargs = oldParams.length - 1;
            if (this.index < 0) {
                int i;
                int newNumNonVarargs;
                int absIndex = -this.index;
                if (absIndex > numNonVarargs) {
                    gobbledParams = numNonVarargs;
                }
                if (absIndex - this.curriedArguments.length > (newNumNonVarargs = numNonVarargs - gobbledParams)) {
                    extraParams = absIndex - this.curriedArguments.length - newNumNonVarargs;
                }
                int keptParams = Math.max(numNonVarargs - absIndex, 0);
                Class[] newParams = new Class[keptParams + newNumNonVarargs + extraParams + 1];
                System.arraycopy(oldParams, 0, newParams, 0, keptParams);
                for (i = 0; i < newNumNonVarargs; ++i) {
                    newParams[keptParams + i] = Object.class;
                }
                for (i = 0; i < extraParams; ++i) {
                    newParams[keptParams + newNumNonVarargs + i] = this.varargType.getComponentType();
                }
                newParams[newParams.length - 1] = this.varargType;
                return newParams;
            }
            int leadingKept = Math.min(this.index, numNonVarargs);
            int trailingKept = Math.max(numNonVarargs - leadingKept - this.curriedArguments.length, 0);
            if (this.index > leadingKept) {
                extraParams = this.index - leadingKept;
            }
            Class[] newParams = new Class[leadingKept + trailingKept + extraParams + 1];
            System.arraycopy(oldParams, 0, newParams, 0, leadingKept);
            if (trailingKept > 0) {
                System.arraycopy(oldParams, leadingKept + this.curriedArguments.length, newParams, leadingKept, trailingKept);
            }
            for (int i = 0; i < extraParams; ++i) {
                newParams[leadingKept + trailingKept + i] = this.varargType.getComponentType();
            }
            newParams[newParams.length - 1] = this.varargType;
            return newParams;
        }
        Class[] newParams = new Class[oldParams.length - gobbledParams + extraParams];
        System.arraycopy(oldParams, 0, newParams, 0, this.index);
        if (newParams.length - this.index > 0) {
            System.arraycopy(oldParams, this.curriedArguments.length + this.index, newParams, this.index, newParams.length - this.index);
        }
        return newParams;
    }

    private boolean isVararg() {
        return this.varargType != null;
    }
}

