/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.jspecify.annotations.Nullable;

public class StyledException
extends GradleException {
    private static final Logger LOGGER = Logging.getLogger(StyledException.class);
    private static final Pattern STYLES_REGEX = Pattern.compile("<([A-Za-z]+)>(?:<([A-Za-z]+)>)*(.*?)(?:</\\2>)*</\\1>");
    private final String styledMessage;

    public StyledException() {
        this.styledMessage = "";
    }

    public StyledException(String message) {
        super(StyledException.unstyled(message));
        this.styledMessage = message;
    }

    private static String unstyled(String message) {
        Matcher matcher = STYLES_REGEX.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, "$3");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public StyledException(String message, @Nullable Throwable cause) {
        super(StyledException.unstyled(message), cause);
        this.styledMessage = message;
    }

    public static String style(StyledTextOutput.Style style, String text) {
        if (text == null) {
            return null;
        }
        return "<" + style + ">" + text + "</" + style + ">";
    }

    public void render(StyledTextOutput output) {
        Matcher matcher = STYLES_REGEX.matcher(this.styledMessage);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            buf.setLength(0);
            matcher.appendReplacement(buf, "");
            output.text((Object)buf);
            String styleText = matcher.group(1);
            String txt = matcher.group(3);
            StyledTextOutput.Style style = StyledException.toStyle(styleText);
            output.withStyle(style).text((Object)txt);
        }
        buf.setLength(0);
        matcher.appendTail(buf);
        output.text((Object)buf.toString());
    }

    private static StyledTextOutput.Style toStyle(String styleText) {
        try {
            return StyledTextOutput.Style.valueOf((String)StringUtils.capitalize((String)styleText));
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Style '{}' doesn't exist", (Object)styleText);
            return StyledTextOutput.Style.Normal;
        }
    }
}

