# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ArtifactRegistry
      module V1
        module ArtifactRegistry
          # Path helper methods for the ArtifactRegistry API.
          module Paths
            ##
            # Create a fully-qualified DockerImage resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/dockerImages/{docker_image}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param docker_image [String]
            #
            # @return [::String]
            def docker_image_path project:, location:, repository:, docker_image:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/dockerImages/#{docker_image}"
            end

            ##
            # Create a fully-qualified File resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/files/{file}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param file [String]
            #
            # @return [::String]
            def file_path project:, location:, repository:, file:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/files/#{file}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified MavenArtifact resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/mavenArtifacts/{maven_artifact}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param maven_artifact [String]
            #
            # @return [::String]
            def maven_artifact_path project:, location:, repository:, maven_artifact:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/mavenArtifacts/#{maven_artifact}"
            end

            ##
            # Create a fully-qualified NpmPackage resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/npmPackages/{npm_package}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param npm_package [String]
            #
            # @return [::String]
            def npm_package_path project:, location:, repository:, npm_package:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/npmPackages/#{npm_package}"
            end

            ##
            # Create a fully-qualified Package resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/packages/{package}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param package [String]
            #
            # @return [::String]
            def package_path project:, location:, repository:, package:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/packages/#{package}"
            end

            ##
            # Create a fully-qualified ProjectSettings resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/projectSettings`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_settings_path project:
              "projects/#{project}/projectSettings"
            end

            ##
            # Create a fully-qualified PythonPackage resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/pythonPackages/{python_package}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param python_package [String]
            #
            # @return [::String]
            def python_package_path project:, location:, repository:, python_package:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/pythonPackages/#{python_package}"
            end

            ##
            # Create a fully-qualified Repository resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            #
            # @return [::String]
            def repository_path project:, location:, repository:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}"
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/secrets/{secret}/versions/{secret_version}`
            #
            # @param project [String]
            # @param secret [String]
            # @param secret_version [String]
            #
            # @return [::String]
            def secret_version_path project:, secret:, secret_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

              "projects/#{project}/secrets/#{secret}/versions/#{secret_version}"
            end

            ##
            # Create a fully-qualified Tag resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/tags/{tag}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param package [String]
            # @param tag [String]
            #
            # @return [::String]
            def tag_path project:, location:, repository:, package:, tag:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"
              raise ::ArgumentError, "package cannot contain /" if package.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/packages/#{package}/tags/#{tag}"
            end

            ##
            # Create a fully-qualified Version resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/versions/{version}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param package [String]
            # @param version [String]
            #
            # @return [::String]
            def version_path project:, location:, repository:, package:, version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"
              raise ::ArgumentError, "package cannot contain /" if package.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/packages/#{package}/versions/#{version}"
            end

            ##
            # Create a fully-qualified VpcscConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/vpcscConfig`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def vpcsc_config_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}/vpcscConfig"
            end

            extend self
          end
        end
      end
    end
  end
end
