function createWebSocketURL(t){if("function"==typeof t&&(t=t()),t&&!/^wss?:/i.test(t)){const e=document.createElement("a");return e.href=t,e.href=e.href,e.protocol=e.protocol.replace("http","ws"),e.href}return t}function createConsumer(t=getConfig("url")||INTERNAL.default_mount_path){return new Consumer(t)}function getConfig(t){const e=document.head.querySelector(`meta[name='action-cable-${t}']`);if(e)return e.getAttribute("content")}var adapters={logger:"undefined"!=typeof console?console:void 0,WebSocket:"undefined"!=typeof WebSocket?WebSocket:void 0},logger={log(...t){this.enabled&&(t.push(Date.now()),adapters.logger.log("[ActionCable]",...t))}};const now=()=>(new Date).getTime(),secondsSince=t=>(now()-t)/1e3;class ConnectionMonitor{constructor(t){this.visibilityDidChange=this.visibilityDidChange.bind(this),this.connection=t,this.reconnectAttempts=0}start(){this.isRunning()||(this.startedAt=now(),delete this.stoppedAt,this.startPolling(),addEventListener("visibilitychange",this.visibilityDidChange),logger.log(`ConnectionMonitor started. stale threshold = ${this.constructor.staleThreshold} s`))}stop(){this.isRunning()&&(this.stoppedAt=now(),this.stopPolling(),removeEventListener("visibilitychange",this.visibilityDidChange),logger.log("ConnectionMonitor stopped"))}isRunning(){return this.startedAt&&!this.stoppedAt}recordPing(){this.pingedAt=now()}recordConnect(){this.reconnectAttempts=0,this.recordPing(),delete this.disconnectedAt,logger.log("ConnectionMonitor recorded connect")}recordDisconnect(){this.disconnectedAt=now(),logger.log("ConnectionMonitor recorded disconnect")}startPolling(){this.stopPolling(),this.poll()}stopPolling(){clearTimeout(this.pollTimeout)}poll(){this.pollTimeout=setTimeout(()=>{this.reconnectIfStale(),this.poll()},this.getPollInterval())}getPollInterval(){const{staleThreshold:t,reconnectionBackoffRate:e}=this.constructor;return 1e3*t*Math.pow(1+e,Math.min(this.reconnectAttempts,10))*(1+(0===this.reconnectAttempts?1:e)*Math.random())}reconnectIfStale(){this.connectionIsStale()&&(logger.log(`ConnectionMonitor detected stale connection. reconnectAttempts = ${this.reconnectAttempts}, time stale = ${secondsSince(this.refreshedAt)} s, stale threshold = ${this.constructor.staleThreshold} s`),this.reconnectAttempts++,this.disconnectedRecently()?logger.log(`ConnectionMonitor skipping reopening recent disconnect. time disconnected = ${secondsSince(this.disconnectedAt)} s`):(logger.log("ConnectionMonitor reopening"),this.connection.reopen()))}get refreshedAt(){return this.pingedAt?this.pingedAt:this.startedAt}connectionIsStale(){return secondsSince(this.refreshedAt)>this.constructor.staleThreshold}disconnectedRecently(){return this.disconnectedAt&&secondsSince(this.disconnectedAt)<this.constructor.staleThreshold}visibilityDidChange(){"visible"===document.visibilityState&&setTimeout(()=>{!this.connectionIsStale()&&this.connection.isOpen()||(logger.log("ConnectionMonitor reopening stale connection on visibilitychange. visibilityState = "+document.visibilityState),this.connection.reopen())},200)}}ConnectionMonitor.staleThreshold=6,ConnectionMonitor.reconnectionBackoffRate=.15;var INTERNAL={message_types:{welcome:"welcome",disconnect:"disconnect",ping:"ping",confirmation:"confirm_subscription",rejection:"reject_subscription"},disconnect_reasons:{unauthorized:"unauthorized",invalid_request:"invalid_request",server_restart:"server_restart",remote:"remote"},default_mount_path:"/cable",protocols:["actioncable-v1-json","actioncable-unsupported"]};const{message_types:message_types,protocols:protocols}=INTERNAL,supportedProtocols=protocols.slice(0,protocols.length-1),indexOf=[].indexOf;class Connection{constructor(t){this.open=this.open.bind(this),this.consumer=t,this.subscriptions=this.consumer.subscriptions,this.monitor=new ConnectionMonitor(this),this.disconnected=!0}send(t){return!!this.isOpen()&&(this.webSocket.send(JSON.stringify(t)),!0)}open(){if(this.isActive())return logger.log("Attempted to open WebSocket, but existing socket is "+this.getState()),!1;{const t=[...protocols,...this.consumer.subprotocols||[]];return logger.log(`Opening WebSocket, current state is ${this.getState()}, subprotocols: ${t}`),this.webSocket&&this.uninstallEventHandlers(),this.webSocket=new adapters.WebSocket(this.consumer.url,t),this.installEventHandlers(),this.monitor.start(),!0}}close({allowReconnect:t}={allowReconnect:!0}){if(t||this.monitor.stop(),this.isOpen())return this.webSocket.close()}reopen(){if(logger.log("Reopening WebSocket, current state is "+this.getState()),!this.isActive())return this.open();try{return this.close()}catch(t){logger.log("Failed to reopen WebSocket",t)}finally{logger.log(`Reopening WebSocket in ${this.constructor.reopenDelay}ms`),setTimeout(this.open,this.constructor.reopenDelay)}}getProtocol(){if(this.webSocket)return this.webSocket.protocol}isOpen(){return this.isState("open")}isActive(){return this.isState("open","connecting")}triedToReconnect(){return this.monitor.reconnectAttempts>0}isProtocolSupported(){return indexOf.call(supportedProtocols,this.getProtocol())>=0}isState(...t){return indexOf.call(t,this.getState())>=0}getState(){if(this.webSocket)for(let t in adapters.WebSocket)if(adapters.WebSocket[t]===this.webSocket.readyState)return t.toLowerCase();return null}installEventHandlers(){for(let t in this.events){const e=this.events[t].bind(this);this.webSocket["on"+t]=e}}uninstallEventHandlers(){for(let t in this.events)this.webSocket["on"+t]=function(){}}}Connection.reopenDelay=500,Connection.prototype.events={message(t){if(!this.isProtocolSupported())return;const{identifier:e,message:n,reason:i,reconnect:o,type:s}=JSON.parse(t.data);switch(s){case message_types.welcome:return this.triedToReconnect()&&(this.reconnectAttempted=!0),this.monitor.recordConnect(),this.subscriptions.reload();case message_types.disconnect:return logger.log("Disconnecting. Reason: "+i),this.close({allowReconnect:o});case message_types.ping:return this.monitor.recordPing();case message_types.confirmation:return this.subscriptions.confirmSubscription(e),this.reconnectAttempted?(this.reconnectAttempted=!1,this.subscriptions.notify(e,"connected",{reconnected:!0})):this.subscriptions.notify(e,"connected",{reconnected:!1});case message_types.rejection:return this.subscriptions.reject(e);default:return this.subscriptions.notify(e,"received",n)}},open(){if(logger.log(`WebSocket onopen event, using '${this.getProtocol()}' subprotocol`),this.disconnected=!1,!this.isProtocolSupported())return logger.log("Protocol is unsupported. Stopping monitor and disconnecting."),this.close({allowReconnect:!1})},close(t){if(logger.log("WebSocket onclose event"),!this.disconnected)return this.disconnected=!0,this.monitor.recordDisconnect(),this.subscriptions.notifyAll("disconnected",{willAttemptReconnect:this.monitor.isRunning()})},error(){logger.log("WebSocket onerror event")}};const extend=function(t,e){if(null!=e)for(let n in e){const i=e[n];t[n]=i}return t};class Subscription{constructor(t,e={},n){this.consumer=t,this.identifier=JSON.stringify(e),extend(this,n)}perform(t,e={}){return e.action=t,this.send(e)}send(t){return this.consumer.send({command:"message",identifier:this.identifier,data:JSON.stringify(t)})}unsubscribe(){return this.consumer.subscriptions.remove(this)}}class SubscriptionGuarantor{constructor(t){this.subscriptions=t,this.pendingSubscriptions=[]}guarantee(t){-1==this.pendingSubscriptions.indexOf(t)?(logger.log("SubscriptionGuarantor guaranteeing "+t.identifier),this.pendingSubscriptions.push(t)):logger.log("SubscriptionGuarantor already guaranteeing "+t.identifier),this.startGuaranteeing()}forget(t){logger.log("SubscriptionGuarantor forgetting "+t.identifier),this.pendingSubscriptions=this.pendingSubscriptions.filter(e=>e!==t)}startGuaranteeing(){this.stopGuaranteeing(),this.retrySubscribing()}stopGuaranteeing(){clearTimeout(this.retryTimeout)}retrySubscribing(){this.retryTimeout=setTimeout(()=>{this.subscriptions&&"function"==typeof this.subscriptions.subscribe&&this.pendingSubscriptions.map(t=>{logger.log("SubscriptionGuarantor resubscribing "+t.identifier),this.subscriptions.subscribe(t)})},500)}}class Subscriptions{constructor(t){this.consumer=t,this.guarantor=new SubscriptionGuarantor(this),this.subscriptions=[]}create(t,e){const n="object"==typeof t?t:{channel:t},i=new Subscription(this.consumer,n,e);return this.add(i)}add(t){return this.subscriptions.push(t),this.consumer.ensureActiveConnection(),this.notify(t,"initialized"),this.subscribe(t),t}remove(t){return this.forget(t),this.findAll(t.identifier).length||this.sendCommand(t,"unsubscribe"),t}reject(t){return this.findAll(t).map(t=>(this.forget(t),this.notify(t,"rejected"),t))}forget(t){return this.guarantor.forget(t),this.subscriptions=this.subscriptions.filter(e=>e!==t),t}findAll(t){return this.subscriptions.filter(e=>e.identifier===t)}reload(){return this.subscriptions.map(t=>this.subscribe(t))}notifyAll(t,...e){return this.subscriptions.map(n=>this.notify(n,t,...e))}notify(t,e,...n){let i;return i="string"==typeof t?this.findAll(t):[t],i.map(t=>"function"==typeof t[e]?t[e](...n):void 0)}subscribe(t){this.sendCommand(t,"subscribe")&&this.guarantor.guarantee(t)}confirmSubscription(t){logger.log("Subscription confirmed "+t),this.findAll(t).map(t=>this.guarantor.forget(t))}sendCommand(t,e){const{identifier:n}=t;return this.consumer.send({command:e,identifier:n})}}class Consumer{constructor(t){this._url=t,this.subscriptions=new Subscriptions(this),this.connection=new Connection(this),this.subprotocols=[]}get url(){return createWebSocketURL(this._url)}send(t){return this.connection.send(t)}connect(){return this.connection.open()}disconnect(){return this.connection.close({allowReconnect:!1})}ensureActiveConnection(){if(!this.connection.isActive())return this.connection.open()}addSubProtocol(t){this.subprotocols=[...this.subprotocols,t]}}export{Connection,ConnectionMonitor,Consumer,INTERNAL,Subscription,SubscriptionGuarantor,Subscriptions,adapters,createConsumer,createWebSocketURL,getConfig,logger};