---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: イシューを作成する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 製品: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イシューを作成する際、イシューのフィールドに入力するように求められます。イシューに割り当てる値がわかっている場合は、[クイックアクション](../quick_actions.md)を使用してその値を入力できます。

GitLabでは、次の複数の方法でイシューを作成できます。

- [プロジェクトから](#from-a-project)
- [グループから](#from-a-group)
- [別のイシューまたはインシデントから](#from-another-issue-or-incident)
- [イシューボードから](#from-an-issue-board)
- [メールを送信する](#by-sending-an-email)
- [値を事前に入力したURLを使用する](#using-a-url-with-prefilled-values)
- [サービスデスクを使用する](#using-service-desk)

## プロジェクトから

前提要件:

- プロジェクトのゲストロール以上を持っている必要があります。

イシューを作成するには:

1. 左側のサイドバーで**検索または移動**を選択して、プロジェクトを見つけます。
1. 次のいずれかの操作を行います。

   - 左側のサイドバーで**計画 > イシュー**を選択し、右上隅の**新しいイシュー**を選択します。
   - 左側のサイドバーの上部にあるプラス記号（{{< icon name="plus" >}}）を選択し、**このプロジェクト内で**で**新しいイシュー**を選択します。

1. [フィールド](#fields-in-the-new-issue-form)に入力します。
1. **イシューを作成する**を選択します。

新しく作成されたイシューが開きます。

## グループから

イシューはプロジェクトに属していますが、グループにいる場合は、グループ内のプロジェクトに属するイシューにアクセスしたり、作成したりできます。

前提要件:

- グループ内のプロジェクトのゲストロール以上を持っている必要があります。

グループからイシューを作成するには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **計画 > イシュー**を選択します。
1. 右上隅で、**イシューを作成するプロジェクトを選択**を選択します。
1. イシューを作成するプロジェクトを選択します。ボタンに選択したプロジェクトが反映されます。
1. **`<project name>`の新しいイシュー**を選択します。
1. [フィールド](#fields-in-the-new-issue-form)に入力します。
1. **イシューを作成する**を選択します。

新しく作成されたイシューが開きます。

最近選択したプロジェクトが、次回のアクセス時のデフォルトになります。主に同じプロジェクトのイシューを作成する場合は、これにより時間を大幅に節約できます。

## 別のイシューまたはインシデントから

既存のイシューから新しいイシューを作成できます。2つのイシューを関連としてマークできます。

前提要件:

- プロジェクトのゲストロール以上を持っている必要があります。

別のイシューからイシューを作成するには:

1. 既存のイシューで、**イシューアクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **新しい関連イシュー**を選択します。
1. [フィールド](#fields-in-the-new-issue-form)に入力します。新しいイシューフォームには、**イシュー#123に関連付ける**チェックボックスがあります。ここで、`123`は元のイシューのIDです。このチェックボックスをオンのままにすると、2つのイシューが[リンク](related_issues.md)されます。
1. **イシューを作成する**を選択します。

新しく作成されたイシューが開きます。

## イシューボードから

[イシューボード](../issue_board.md)から新しいイシューを作成できます。

前提要件:

- プロジェクトのゲストロール以上を持っている必要があります。

プロジェクトイシューボードからイシューを作成するには:

1. 左側のサイドバーで**検索または移動**を選択して、プロジェクトを見つけます。
1. **計画 > イシューボード**を選択します。
1. ボードリストの上部で、**イシューの新規作成**（{{< icon name="plus-square" >}}）を選択します。
1. イシューのタイトルを入力します。
1. **イシューを作成する**を選択します。

グループイシューボードからイシューを作成するには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **計画 > イシューボード**を選択します。
1. ボードリストの上部で、**イシューの新規作成**（{{< icon name="plus-square" >}}）を選択します。
1. イシューのタイトルを入力します。
1. **プロジェクト**で、イシューを割り当てる必要があるグループ内のプロジェクトを選択します。
1. **イシューを作成する**を選択します。

イシューが作成され、ボードリストに表示されます。リストの特性を共有するため、たとえば、リストのスコープがラベル`Frontend`に設定されている場合、新しいイシューにもこのラベルが設定されます。

## メールを送信する

プロジェクトの**イシュー**ページでプロジェクトのイシューを作成するメールを送信できます。

前提要件:

- GitLabインスタンスで、[メールサブアドレス指定またはすべてをキャッチするメールボックス](../../../administration/incoming_email.md#requirements)を使用して[受信メール](../../../administration/incoming_email.md)が設定されている必要があります。
- イシューリストに少なくとも1つのイシューが必要です。
- プロジェクトのゲストロール以上を持っている必要があります。

プロジェクトにイシューをメールで送信するには:

1. 左側のサイドバーで**検索または移動**を選択して、プロジェクトを見つけます。
1. **計画 > イシュー**を選択します。
1. ページの下部で、**新しいイシューをこのプロジェクトにメール**を選択します。
1. **コピー**（{{< icon name="copy-to-clipboard" >}}）を選択して、メールアドレスをコピーします。
1. メールクライアントから、このアドレスにメールを送信します。件名は新しいイシューのタイトルとして使用され、メール本文は説明になります。[Markdown](../../markdown.md)と[クイックアクション](../quick_actions.md)を使用できます。

新しいイシューが作成され、ユーザーが作成者になります。このアドレスを連絡先としてメールクライアントに保存して、再度使用できます。

{{< alert type="warning" >}}

表示されるメールアドレスは、ユーザー専用に生成されたプライベートメールアドレスです。このメールアドレスを知っている人は誰でもそのユーザーとしてイシューまたはマージリクエストを作成できるため、**秘密にしておいてください**。

{{< /alert >}}

メールアドレスを再度生成するには:

1. **イシュー**ページで、**新しいイシューをこのプロジェクトにメール**を選択します。
1. **このトークンをリセット**を選択します。

## 値を事前に入力したURLを使用する

フィールドが事前に入力された新しいイシューページに直接リンクするには、URLでクエリ文字列パラメーターを使用します。外部HTMLページにURLを埋め込んで、特定のフィールドが事前に入力されたイシューを作成できます。

| フィールド                | URLパラメーター         | ノート                                                                                                                           |
| -------------------- | --------------------- | ------------------------------------------------------------------------------------------------------------------------------- |
| タイトル                | `issue[title]`        | [URLエンコード](../../../api/rest/_index.md#namespaced-paths)する必要があります。                                                          |
| イシュータイプ           | `issue[issue_type]`   | `incident`または`issue`のいずれか。                                                                                                   |
| 説明テンプレート（イシュー、エピック、インシデント、マージリクエスト） | `issuable_template`   | [URLエンコード](../../../api/rest/_index.md#namespaced-paths)する必要があります。                                                          |
| 説明テンプレート（タスク、OKR、[新しい外観](../../group/epics/epic_work_items.md)のエピック） | `description_template`   | [URLエンコード](../../../api/rest/_index.md#namespaced-paths)する必要があります。GitLab 17.9で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/513095)。 |
| 説明          | `issue[description]`  | [URLエンコード](../../../api/rest/_index.md#namespaced-paths)する必要があります。`issuable_template`または[デフォルトのイシューテンプレート](../description_templates.md#set-a-default-template-for-merge-requests-and-issues)と組み合わせて使用​​すると、`issue[description]`の値がテンプレートに付け加えられます。 |
| 機密         | `issue[confidential]` | `true`の場合、イシューは機密としてマークされます。                                                                                 |
| 関連付ける…           | `add_related_issue`   | 数値イシューID。存在する場合、イシューフォームには、新しいイシューを指定された既存のイシューにオプションでリンクするための[**関連付ける**チェックボックス](#from-another-issue-or-incident)が表示されます。 |

[GitLab 17.8以降](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177215)では、イシューテンプレートを選択すると、URLが変更されて使用するテンプレートを示します。

これらの例を参考に、フィールドが事前に入力された新しいイシューURLを作成してください。GitLabプロジェクトでイシューを作成するには、次のように指定します。

- 事前に入力されたタイトルと説明:

  ```plaintext
  https://gitlab.com/gitlab-org/gitlab/-/issues/new?issue[title]=Whoa%2C%20we%27re%20half-way%20there&issue[description]=Whoa%2C%20livin%27%20in%20a%20URL
  ```

- 事前に入力されたタイトルと説明テンプレート:

  ```plaintext
  https://gitlab.com/gitlab-org/gitlab/-/issues/new?issue[title]=Validate%20new%20concept&issuable_template=Feature%20Proposal%20-%20basic
  ```

- 事前に入力されたタイトル、説明、および機密としてマーク:

  ```plaintext
  https://gitlab.com/gitlab-org/gitlab/-/issues/new?issue[title]=Validate%20new%20concept&issue[description]=Research%20idea&issue[confidential]=true
  ```

## サービスデスクを使用する

メールサポートを提供するには、プロジェクトに対して[サービスデスク](../service_desk/_index.md)を有効にします。

これで、お客様が新しいメールを送信すると、適切なプロジェクトに新しいイシューが作成され、そこからフォローアップできるようになります。

## 新しいイシューフォームのフィールド

{{< history >}}

- GitLab 15.6で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/233517)されたイテレーションフィールド。

{{< /history >}}

新しいイシューを作成するときは、次のフィールドに入力できます。

- タイトル
- タイプ: イシュー（デフォルト）またはインシデント
- [説明テンプレート](../description_templates.md): 説明テキストボックス内のすべてを上書きします
- 説明: [Markdown](../../markdown.md)と[クイックアクション](../quick_actions.md)を使用できます
- イシューを[機密](confidential_issues.md)にするためのチェックボックス
- [担当者](managing_issues.md#assignees)
- [ウェイト](issue_weight.md)
- [エピック](../../group/epics/_index.md)
- [期限](due_dates.md)
- [マイルストーン](../milestones/_index.md)
- [ラベル](../labels.md)
- [イテレーション](../../group/iterations/_index.md)
