---
stage: Foundations
group: Import and Integrate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: グループとプロジェクトのインポートと移行
---

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

既存の作業を GitLab に取り込み、コントリビュート履歴を保持します。複数のプラットフォームからプロジェクトを統合するか、GitLab インスタンス間でデータを転送します。

GitLab には、次の方法があります:

- 直接転送を使用して GitLab グループとプロジェクトを移行します。
- さまざまなサポート対象ソースからプロジェクトをインポートします。

## 直接転送を使用して GitLab から GitLab に移行する

GitLab インスタンス間、または同じ GitLab インスタンス内で GitLab グループとプロジェクトをコピーする最適な方法は、[直接転送を使用すること](../../group/import/_index.md)です。

別のオプションは、[グループ転送](../../group/manage.md#transfer-a-group)を使用して GitLab グループを移動することです。

GitLab ファイルのエクスポートを使用しても GitLabプロジェクトをコピーできます。これは、サポートされているインポート元です。

## サポートされているインポート元

{{< history >}}

- すべてのインポーターは、GitLab Self-Managed インストールではデフォルトで無効になっています。この変更は、GitLab 16.0 で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118970)されました。

{{< /history >}}

デフォルトで使用できるインポート元は、使用する GitLab によって異なります。

- GitLab.com: 使用可能なすべてのインポート元は、[デフォルトで有効](../../gitlab_com/_index.md#default-import-sources)になっています。
- GitLab Self-Managed: インポート元はデフォルトで有効になっていないため、[有効にする](../../../administration/settings/import_and_export_settings.md#configure-allowed-import-sources)必要があります。

GitLab は、これらのサポートされているインポート元からプロジェクトをインポートできます。

| インポート元                                 | 説明 |
|:----------------------------------------------|:------------|
| [Bitbucket Cloud](bitbucket.md)               | [Bitbucket.org を OmniAuth プロバイダーとして使用](../../../integration/bitbucket.md)して、Bitbucket リポジトリをインポートします。 |
| [Bitbucket Server](bitbucket_server.md)       | Bitbucket Server (Stash とも呼ばれます) からリポジトリをインポートします。 |
| [FogBugz](fogbugz.md)                         | FogBugz プロジェクトをインポートします。 |
| [Gitea](gitea.md)                             | Gitea プロジェクトをインポートします。 |
| [GitHub](github.md)                           | GitHub.com または GitHub Enterprise からインポートします。 |
| [GitLab エクスポート](../settings/import_export.md) | GitLab エクスポートファイルを使用して、プロジェクトを 1 つずつ移行します。 |
| [manifest ファイル](manifest.md)                  | manifest ファイルをアップロードします。 |
| [URL によるリポジトリ](repo_by_url.md)           | Gitリポジトリ URL を指定して、新しいプロジェクトを作成します。 |

移行を開始した後、移行元インスタンスでインポートされたグループまたはプロジェクトを変更しないでください。これらの変更が移行先インスタンスにコピーされない可能性があります。

### 未使用のインポート元を無効にする

信頼できるソースからのみプロジェクトをインポートします。信頼できないソースからプロジェクトをインポートすると、攻撃者が機密データを盗む可能性があります。たとえば、悪意のある `.gitlab-ci.yml` ファイルを含むインポートされたプロジェクトでは、攻撃者がグループ CI/CD変数を流出させる可能性があります。

GitLab Self-Managed の管理者は、不要なインポート元を無効にすることで、アタックサーフェス（攻撃対象領域）を削減できます。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定 > 一般**を選択します。
1. **インポートおよびエクスポート設定**を展開します。
1. **インポート元**までスクロールします。
1. 不要なインポーターのチェックボックスをオフにします。

## その他のインポート元

次のその他のインポート元からのインポートに関する情報を読むこともできます。

- [ClearCase](clearcase.md)
- [Concurrent Versions System (CVS)](cvs.md)
- [Jira（イシューのみ）](jira.md)
- [Perforce Helix](perforce.md)
- [Team Foundation Version Control (TFVC)](tfvc.md)

### サブバージョンからリポジトリをインポートする

GitLab は、サブバージョンリポジトリを Git に自動的に移行することはできません。サブバージョンリポジトリから Git への変換は困難な場合がありますが、次のようなツールがいくつか存在します。

- [`git svn`](https://git-scm.com/book/en/v2/Git-and-Other-Systems-Migrating-to-Git) は、非常に小さく基本的なリポジトリ用です。
- [`reposurgeon`](http://www.catb.org/~esr/reposurgeon/repository-editing.html) は、より大きく複雑なリポジトリ用です。

## ユーザーのコントリビュートとメンバーシップのマッピング

{{< details >}}

- 提供:GitLab.com、GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.4 で、`importer_user_mapping` および `bulk_import_importer_user_mapping` という名前の[フラグ付き](../../../administration/feature_flags.md)の直接転送[で導入](https://gitlab.com/gitlab-org/gitlab/-/issues/443557)されました。デフォルトでは無効になっています。
- `importer_user_mapping` および `gitea_user_mapping` という名前の[フラグ付き](../../../administration/feature_flags.md)で Gitea に、`importer_user_mapping` および `github_user_mapping` という名前のフラグ付きで [GitHub](https://gitlab.com/gitlab-org/gitlab/-/issues/466355)にGitLab 17.6 で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/467084)されました。デフォルトでは無効になっています。
- GitLab 17.7 で、`importer_user_mapping` および `bitbucket_server_user_mapping` という名前の[フラグ付き](../../../administration/feature_flags.md)で Bitbucket Server に[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/466356)されました。デフォルトでは無効になっています。
- GitLab 17.7 の[GitLab.com および GitLab Self-Managed で有効](https://gitlab.com/gitlab-org/gitlab/-/issues/472735)（直接転送の場合）。
- GitLab 17.7 の GitLab.com で[Bitbucket Server](https://gitlab.com/gitlab-org/gitlab/-/issues/509897)、[Gitea](https://gitlab.com/gitlab-org/gitlab/-/issues/498390)、および[GitHub](https://gitlab.com/gitlab-org/gitlab/-/issues/499993)で有効になりました。
- GitLab 17.8 の GitLab Self-Managed で[Bitbucket Server](https://gitlab.com/gitlab-org/gitlab/-/issues/509897)、[Gitea](https://gitlab.com/gitlab-org/gitlab/-/issues/498390)、および[GitHub](https://gitlab.com/gitlab-org/gitlab/-/issues/499993)で有効になりました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

{{< alert type="note" >}}

この機能に関するフィードバックを残すには、[イシュー 502565](https://gitlab.com/gitlab-org/gitlab/-/issues/502565)にコメントを追加してください。

{{< /alert >}}

このユーザーコントリビュートおよびメンバーシップマッピングの方法は、GitLab.com および GitLab Self-Managed の[直接転送](../../group/import/_index.md)、[GitHub インポーター](github.md)、[Bitbucket Server インポーター](bitbucket_server.md)、および[Gitea インポーター](gitea.md)でデフォルトで使用できます。機能フラグが無効になっている GitLab Self-Managed で利用可能な別の方法については、各インポーターのドキュメントを参照してください。

プロジェクトを[個人ネームスペース](../../../user/namespace/_index.md#types-of-namespaces)にインポートする場合、ユーザーコントリビュートマッピングはサポートされていません。個人ネームスペースにインポートする場合、すべてのコントリビュートは `Import User` という単一の非機能ユーザーに割り当てられ、再アサインすることはできません。

インポートするメンバーシップとコントリビュートは、最初に[プレースホルダーユーザー](#placeholder-users)にマッピングされます。これらのプレースホルダーは、移行元インスタンスに同じメールアドレスを持つユーザーが存在する場合でも、移行先インスタンスに作成されます。移行先インスタンスでコントリビュートを再アサインするまで、すべてのコントリビュートはプレースホルダーに関連付けられているものとして表示されます。同じトップレベルグループへの後続のインポートに関連付けられた動作については、[プレースホルダーユーザー制限](#placeholder-user-limits)を参照してください。

インポートが完了したら、次のことができます:

- 結果をレビューした後、移行先インスタンスの既存のユーザーにメンバーシップとコントリビュートを再アサインします。移行元インスタンスと移行先インスタンスで異なるメールアドレスを持つユーザーのメンバーシップとコントリビュートをマッピングできます。
- メンバーシップとコントリビュートを再アサインするために、移行先インスタンスで新しいユーザーを作成します。

コントリビュートを移行先インスタンスのユーザーに再アサインすると、ユーザーは再アサインを[承認](#accept-contribution-reassignment)または[拒否](#reject-contribution-reassignment)できます。

### 要求事項

- [ユーザー制限](#placeholder-user-limits)に従って、十分な数のユーザーを作成できる必要があります。
- GitLab.com にインポートする場合は、インポートする前に有料のネームスペースを設定する必要があります。
- GitLab.com にインポートし、[GitLab.com グループに SAML SSO](../../group/saml_sso/_index.md)を使用する場合は、[コントリビュートとメンバーシップを再アサイン](#reassign-contributions-and-memberships)する前に、すべてのユーザーが SAML ID を GitLab.com アカウントにリンクする必要があります。

### プレースホルダーユーザー

コントリビュートとメンバーシップを移行先インスタンスのユーザーにすぐに割り当てる代わりに、インポートされたコントリビュートまたはメンバーシップを持つアクティブ、非アクティブ、またはボットのユーザーに対してプレースホルダーユーザーが作成されます。ソースインスタンスで削除されたユーザーの場合、すべての[プレースホルダーユーザー属性](#placeholder-user-attributes)なしでプレースホルダーが作成されます。[これらのユーザーをプレースホルダーとして保持する](#keep-as-placeholder)必要があります。詳細については、[イシュー 506432](https://gitlab.com/gitlab-org/gitlab/-/issues/506432)を参照してください。

コントリビュートとメンバーシップの両方が最初にこれらのプレースホルダーユーザーに割り当てられ、インポート後に移行先インスタンスの既存のユーザーに再アサインできます。再アサインされるまで、コントリビュートはプレースホルダーに関連付けられているものとして表示されます。プレースホルダーのメンバーシップは、メンバーリストには表示されません。

プレースホルダーユーザーは、ライセンス制限にはカウントされません。

#### 例外

プレースホルダーユーザーは、次のシナリオを除き、移行元インスタンスの各ユーザーに対して作成されます:

- [Gitea](gitea.md)からプロジェクトをインポートしており、ユーザーがインポート前に Gitea で削除されている。これらの「Ghostユーザー」からのコントリビュートは、プレースホルダーユーザーではなく、プロジェクトをインポートしたユーザーにマッピングされます。
- [プレースホルダーユーザー制限](#placeholder-user-limits)を超過しました。制限を超過した後の新しいユーザーからのコントリビュートは、`Import User`という単一の非機能ユーザーにマッピングされます。
- [個人ネームスペース](../../../user/namespace/_index.md#types-of-namespaces)にインポートしている。コントリビュートは、`Import User`という単一の非機能ユーザーに割り当てられます。

#### プレースホルダーユーザー属性

プレースホルダーユーザーは通常のユーザーとは異なり、次のことはできません。

- サインイン。
- アクションを実行する。たとえば、パイプラインの実行などです。
- イシューおよびマージリクエストの担当者またはレビュアーとして候補に表示されます。
- プロジェクトおよびグループのメンバーになる。

ソースインスタンス上のユーザーとの接続を維持するために、プレースホルダーユーザーには次のものがあります。

- 新しいプレースホルダーユーザーが必要かどうかをインポートプロセスが判断するために使用する固有識別子（`source_user_id`）。
- ソースホスト名またはドメイン（`source_hostname`）。
- コントリビュートの再アサインを支援するためのソースユーザーの名前（`source_name`）。
- コントリビュートの再アサイン中にグループオーナーを支援するためのソースユーザーのユーザー名(`source_username`)。
- どのインポーターがプレースホルダーを作成したかを区別するインポートタイプ（`import_type`）。
- 移行追跡のために移行元ユーザーが作成されたときのタイムスタンプ（`created_at`）（ローカル時刻）（GitLab 17.10 で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/507297)）。

履歴コンテキストを保持するために、プレースホルダーユーザー名とユーザー名は、移行元ユーザー名とユーザー名から派生します。

- プレースホルダーユーザーの名前は `Placeholder <source user name>` です。
- プレースホルダーユーザーのユーザー名は `%{source_username}_placeholder_user_%{incremental_number}` です。

#### プレースホルダーユーザーを表示する

前提要件:

- グループのオーナーのロールを持っている必要があります。

トップレベルグループとそのサブグループへのインポート中に、プレースホルダーユーザーが移行先インスタンスに作成されます。トップレベルグループとそのサブグループへのインポート中に作成されたプレースホルダーユーザーを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。

#### プレースホルダーユーザー制限

プレースホルダーユーザーは、[インポート元](#supported-import-sources)およびトップレベルグループごとに作成されます。

- 同じプロジェクトを移行先インスタンスの同じトップレベルグループに 2 回インポートする場合、2 回目のインポートでは最初のインポートと同じプレースホルダーユーザーが使用されます。
- 同じプロジェクトを 2 回インポートしても、移行先インスタンスの異なるトップレベルグループにインポートする場合、2 回目のインポートではそのトップレベルグループの下に新しいプレースホルダーユーザーが作成されます。

GitLab.com にインポートする場合、プレースホルダーユーザーは、移行先インスタンスのトップレベルグループごとに制限されます。制限は、プランとシート数によって異なります。プレースホルダーユーザーは、ライセンス制限にはカウントされません。

| GitLab.com のプラン          | シート数 | トップレベルグループのプレースホルダーユーザー制限 |
|:-------------------------|:----------------|:------------------------------------------|
| Free およびすべてのトライアル       | 任意の量      | 200                                       |
| Premium                  | < 100           | 500                                       |
| Premium                  | 101〜500         | 2000                                      |
| Premium                  | 501～1000      | 4000                                      |
| Premium                  | > 1000          | 6000                                      |
| Ultimate およびオープンソース | < 100           | 1000                                      |
| Ultimate およびオープンソース | 101〜500         | 4000                                      |
| Ultimate およびオープンソース | 501～1000      | 6000                                      |
| Ultimate およびオープンソース | > 1000          | 8000                                      |

従来の Bronze、Silver、または Gold プランの顧客には、対応する Free、Premium、または Ultimate の制限が適用されます。Ultimate を試用している Premium 顧客 (Ultimate トライアル有料カスタマープラン) には、Premium 制限が適用されます。これらの制限でインポートに十分でない場合は、[GitLabサポートにお問い合わせください](https://about.gitlab.com/support/)。

GitLab Self-Managed および GitLab Dedicated の場合、デフォルトではプレースホルダー制限は適用されません。GitLab 管理者は、インスタンスの[プレースホルダー制限を設定](../../../administration/instance_limits.md#import-placeholder-user-limits)できます。

現在のプレースホルダーユーザーの使用量と制限を表示するには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **設定 > 利用状況**を選択します。
1. **インポート**タブを選択します。

GitLab.com へのインポートの場合、これらのコントリビュートが同じユーザーにマッピングされるため、一部のコントリビュートが作成されないことがあります。たとえば、複数のマージリクエスト承認者が同じユーザーにマッピングされている場合、最初に行われた承認のみが追加され、他の承認は無視されます。これらのコントリビュートには以下が含まれます。

- メンバーシップ
- マージリクエストの承認、担当者、レビュアー
- イシューの担当者
- 絵文字
- プッシュ、マージリクエスト、およびデプロイのアクセスレベル
- 承認ルール

事前に必要なプレースホルダーユーザーの数を判断することはできません。プレースホルダーユーザー制限に達しても、インポートは失敗しません。代わりに、すべてのコントリビュートは `Import User` という単一の非機能ユーザーに割り当てられます。

すべての変更によってシステムノートが作成されます。これは、プレースホルダーユーザー制限の影響を受けません。

### コントリビュートとメンバーシップの再アサイン

トップレベルグループのオーナーロールを持つユーザーは、コントリビュートとメンバーシップをプレースホルダーユーザーから既存のアクティブ（ボット以外）ユーザーに再アサインできます。移行先インスタンスでは、トップレベルグループのオーナーロールを持つユーザーは、次のことができます。

- [UI で](#request-reassignment-in-ui)または[CSV ファイルを介して](#request-reassignment-by-using-a-csv-file)、ユーザーにコントリビュートとメンバーシップの再アサインをレビューするようリクエストします。多数のプレースホルダーユーザーがいる場合は、CSV ファイルを使用する必要があります。どちらの場合も、ユーザーは再アサインを受け入れるか拒否するためのリクエストをメールで受信します。選択したユーザーが[再アサインリクエストを承認](#accept-contribution-reassignment)した後にのみ、再アサインが開始されます。
- コントリビュートとメンバーシップを再アサインしないことを選択し、[プレースホルダーユーザーに割り当てられたまま](#keep-as-placeholder)にします。

最初に単一のプレースホルダーユーザーに割り当てられたすべてのコントリビュートは、移行先インスタンス上の単一のアクティブな標準ユーザーにのみ再アサインできます。単一のプレースホルダーユーザーに割り当てられたコントリビュートを、複数のアクティブな標準ユーザーに分割することはできません。

移行元インスタンスのボットユーザーのコントリビュートとメンバーシップを、移行先インスタンスのボットユーザーに再アサインすることはできません。移行元のボットユーザーのコントリビュートを[プレースホルダーユーザーに割り当てたまま](#keep-as-placeholder)にすることができます。

再アサインリクエストを受信するユーザーは、次のことができます:

- [リクエストを承認する](#accept-contribution-reassignment)。以前にプレースホルダーユーザーに起因していたすべてのコントリビュートとメンバーシップは、承認ユーザーに再アサインされます。このプロセスには、コントリビュートの数に応じて数分かかる場合があります。
- [リクエストを拒否](#reject-contribution-reassignment)するか、スパムとして報告します。このオプションは、再アサインリクエストメールで利用できます。

同じトップレベルグループへの以降のインポートでは、同じソースユーザーに属するコントリビュートとメンバーシップは、そのソースユーザーの再アサインを以前に承認したユーザーに自動的にマッピングされます。

再アサインプロセスは、次の操作を行う前に完全に完了する必要があります:

- [同じ GitLab インスタンス内でインポートされたグループを移動する](../../group/manage.md#transfer-a-group)。
- [インポートされたプロジェクトを別のグループに移動する](../settings/migrate_projects.md)。
- インポートされたイシューを複製します。
- インポートされたイシューをエピックにプロモートします。

プロセスが完了していない場合、プレースホルダーユーザーに割り当てられたままのコントリビュートは、実際のユーザーに再アサインできず、プレースホルダーユーザーに関連付けられたままになります。

#### セキュリティに関する考慮事項

コントリビュートとメンバーシップの再アサインは元に戻すことができないため、開始する前にすべてを注意深く確認してください。

コントリビュートとメンバーシップを誤ったユーザーに再アサインすると、そのユーザーがグループのメンバーになるため、セキュリティ上の脅威となります。そのため、閲覧を許可されていない情報を閲覧できるようになります。

管理者アクセス権を持つユーザーへのコントリビュートの再アサインはデフォルトで無効になっていますが、[有効に](../../../administration/settings/import_and_export_settings.md#allow-contribution-mapping-to-administrators)することができます。

##### メンバーシップのセキュリティに関する考慮事項

GitLab の権限モデルにより、グループまたはプロジェクトが既存の親グループにインポートされると、親グループのメンバーには、インポートされたグループまたはプロジェクトの[継承されたメンバーシップ](../members/_index.md#membership-types)が付与されます。

インポートされたグループまたはプロジェクトの既存の継承されたメンバーシップをすでに持っているユーザーをコントリビュートとメンバーシップの再アサインに選択すると、メンバーシップがそのユーザーにどのように再アサインされるかに影響を与える可能性があります。

GitLab では、子プロジェクトまたはグループのメンバーシップが、継承されたメンバーシップよりも低いロールを持つことは許可されていません。割り当てられたユーザーのインポートされたメンバーシップが、既存の継承されたメンバーシップよりも低いロールを持っている場合、インポートされたメンバーシップはユーザーに再アサインされません。

その結果、インポートされたグループまたはプロジェクトのメンバーシップが、移行元よりも高い状態になります。

#### UI で再アサインをリクエスト

前提要件:

- グループのオーナーのロールを持っている必要があります。

トップレベルグループでコントリビュートとメンバーシップを再アサインできます。コントリビュートとメンバーシップの再アサインをリクエストするには：

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再アサイン待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. 各プレースホルダーについて、テーブルの列**プレースホルダーユーザー**と**ソース**の情報をレビューします。
1. **再アサイン再割り当て先のプレースホルダー**列で、ドロップダウンリストからユーザーを選択します。
1. **再アサイン再アサイン**を選択します。

1つのプレースホルダーユーザーのコントリビュートのみを、移行先インスタンスのアクティブな非ボットユーザーに再アサイン再アサインできます。

ユーザーが再アサインを承認する前に、[リクエストをキャンセル](#cancel-reassignment-request)できます。

#### CSV ファイルを使用して再アサインをリクエスト

{{< history >}}

- GitLab 17.10 で、`importer_user_mapping_reassignment_csv`という名前の[フラグ](../../../administration/feature_flags.md)を付けて[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/455901)。[デフォルトで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/478022)。

{{< /history >}}

{{< alert type="flag" >}}

この機能の可用性は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

前提要件:

- グループのオーナーのロールを持っている必要があります。

多数のプレースホルダーユーザーの場合、CSV ファイルを使用してコントリビュートとメンバーシップを再アサインすることができます。次の情報を含む、事前入力された CSV テンプレートをダウンロードできます。次に例を示します。

| ソースホスト          | インポートタイプ | ソースユーザー識別子 | ソースユーザーの氏名 | ソースユーザー名 |
|----------------------|-------------|------------------------|------------------|-----------------|
| `gitlab.example.com` | `gitlab`    | `alice`                | `Alice Coder`    | `a.coer`        |

**ソースホスト**、**インポートタイプ**、または**ソースユーザー識別子**を更新しないでください。この情報は、完成した CSV ファイルをアップロードした後で、対応するデータベースレコードを見つけるために使用されます。**ソースユーザーの氏名**と**ソースユーザー名**は、ソースユーザーを識別するものであり、CSV ファイルをアップロードした後は使用されません。

CSV ファイルのすべての行を更新する必要はありません。**GitLab ユーザー名**または**GitLab パブリックメール**を含む行のみが処理されます。他のすべての行はスキップされます。

CSV ファイルを使用してコントリビュートとメンバーシップの再アサインをリクエストするには：

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **CSV で再アサイン**を選択します。
1. 事前入力された CSV テンプレートをダウンロードします。
1. **GitLab ユーザー名**または**GitLab パブリックメール**に、移行先インスタンスの GitLab ユーザーのユーザー名またはパブリックメールアドレスを入力します。インスタンス管理者は、確認済みのメールアドレスを持つユーザーを再アサインできます。
1. 完成した CSV ファイルをアップロードします。
1. **再アサイン再アサイン**を選択します。

単一のプレースホルダーユーザーからのコントリビュートのみを、移行先インスタンスの各アクティブな非ボットユーザーに割り当てることができます。ユーザーは、自分に再アサインされた[コントリビュートをレビューして承認する](#accept-contribution-reassignment)ためのメールを受信します。ユーザーがレビューする前に、[再アサインリクエストをキャンセル](#cancel-reassignment-request)できます。

コントリビュートを再アサインすると、GitLab から次の数が記載されたメールが送信されます。

- 正常に処理された行
- 正常に処理されなかった行
- スキップされた行

正常に処理されなかった行がある場合、メールには、より詳細な結果が記載された CSV ファイルが添付されます。

UI を使用せずにプレースホルダーユーザーを一括で再アサインするには、[グループプレースホルダー再アサイン API](../../../api/group_placeholder_reassignments.md)を参照してください。

#### プレースホルダーとして保持

コントリビュートとメンバーシップを移行先インスタンスのユーザーに再アサインしたくない場合があります。たとえば、移行元インスタンスでコントリビュートした元従業員がいて、移行先インスタンスにユーザーとして存在しない場合があります。

このような場合は、コントリビュートをプレースホルダーユーザーに割り当てたままにすることができます。プレースホルダーユーザーは、[プロジェクトまたはグループのメンバーになることができない](#placeholder-user-attributes)ため、メンバーシップ情報を保持しません。

プレースホルダーユーザーの名前とユーザー名は、移行元ユーザーの名前とユーザー名に似ているため、多くの履歴コンテキストを保持できます。

残りのプレースホルダーユーザーをプレースホルダーとして保持すると、後でそれらのコントリビュートを実際のユーザーに再アサインできなくなることに注意してください。残りのプレースホルダーユーザーをプレースホルダーとして保持する前に、必要なすべての再アサインが完了していることを確認してください。

コントリビュートをプレースホルダーユーザーに割り当てたままにすることは、一度に 1 つずつ行うか、一括で行うことができます。

プレースホルダーユーザーを一度に 1 つずつ保持するには：

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再アサイン待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. **プレースホルダーユーザー**および**ソース**列をレビューして、保持するプレースホルダーユーザーを見つけます。
1. **再アサイン先のプレースホルダー**列で、**再アサインしない**を選択します。
1. **確認**を選択します。

プレースホルダーユーザーを一括で保持するには：

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. リストの上にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）> **すべてをプレースホルダーとして保持**を選択します。
1. 確認ダイアログで、**確認**を選択します。

#### 再アサインリクエストをキャンセル

ユーザーが再アサインリクエストを承認する前に、リクエストをキャンセルできます。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再アサイン待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. 正しい行で**キャンセル**を選択します。

#### 保留中の再アサインリクエストについて、再度ユーザーに通知します

ユーザーが再アサインリクエストに対応していない場合は、別のメールを送信して再度プロンプトを表示できます。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再アサイン待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. 正しい行で**通知**を選択します。

#### 再アサイン状態で表示、フィルター、並べ替えを行う

再再アサインプロセスがまだ完了していないすべてのプレースホルダーユーザーの状態をレビューできます。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理 > メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再アサイン待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. **再アサイン状態**列で、各プレースホルダーユーザーの状態を確認します。

再アサイン状態でフィルターできます。

1. フィルタードロップダウンリストで、**状態**を選択します。
1. 使用可能な状態のいずれかを選択します。

**再アサイン待ち**タブで使用可能な状態は次のとおりです。

- `Not started` - 再アサインは開始されていません。
- `Pending approval` - 再アサインは、ユーザーの承認を待機しています。
- `Reassigning` - 再アサインが進行中です。
- `Rejected` - 再アサインはユーザーによって拒否されました。
- `Failed` - 再アサインに失敗しました。

**再アサイン済**タブで使用可能な状態は次のとおりです。

- `Success` - 再アサインに成功しました。
- `Kept as placeholder` - プレースホルダーユーザーが永続化されました。

デフォルトでは、テーブルはプレースホルダーユーザー名でアルファベット順に並べ替えられています。再アサイン状態でテーブルを並べ替えることもできます。

1. ソートドロップダウンリストで選択します。
1. **再アサイン状態**を選択します。

### コントリビュートの再アサインを承認

インポート処理が行われたことを知らせるメールが届き、コントリビュートを自分自身に再アサインすることを確認するように求められる場合があります。

このインポート処理について知らされた場合でも、再アサインの詳細を非常に注意深くレビューする必要があります。メールに記載されている詳細は次のとおりです。

- **インポート元** \- インポートされたコンテンツの送信元プラットフォーム。たとえば、GitLab、GitHub、または Bitbucket の別のインスタンス。
- **元のユーザー** \- ソースプラットフォーム上のユーザーの氏名とユーザー名。これは、そのプラットフォームでのあなたの氏名とユーザー名である可能性があります。
- **インポート先** \- 新しいプラットフォームの名前。GitLab インスタンスのみです。
- **再アサイン先** \- GitLab インスタンスでのあなたの氏名とユーザー名。
- **再アサイン者** \- インポートを実行した同僚または上司の氏名とユーザー名。

#### コントリビュートの再アサインを拒否

コントリビュートの自分自身への再アサインを確認するように求めるメールを受信し、この情報を認識しない場合、または誤りに気付いた場合は、次のようにします：

1. まったく続行しないでください。または、コントリビュートの再アサインを拒否してください。
1. 信頼できる同僚または上司に相談してください。

#### セキュリティに関する考慮事項

再アサインリクエストの再アサインの詳細を非常に注意深くレビューする必要があります。信頼できる同僚または上司からこのプロセスについて事前に知らされていない場合は、特に注意してください。

疑わしい再アサインを承認するのではなく、次のようにします:

1. メールに対応しないでください。
1. 信頼できる同僚または上司に相談してください。

知っていて信頼できるユーザーからの再アサインのみを承認してください。コントリビュートの再アサインは永続的であり、元に戻すことはできません。再アサインを承認すると、コントリビュートが誤ってあなたに起因する可能性があります。

コントリビュートの再アサインプロセスは、GitLab で**再アサインを承認**を選択して再アサインリクエストを承認した後にのみ開始されます。プロセスは、メール内のリンクを選択しても開始されません。

## プロジェクトのインポート履歴を表示

自分で作成したすべてのプロジェクトインポートを表示できます。このリストには、次のものが含まれています。

- プロジェクトが外部システムからインポートされた場合はソースプロジェクトのパス、または GitLabプロジェクトが移行された場合はインポート方法。
- 移行先プロジェクトのパス。
- 各インポートの開始日。
- 各インポートの状態。
- エラーが発生した場合のエラーの詳細。

プロジェクトのインポート履歴を表示するには：

1. GitLab にサインインします。
1. 左側のサイドバーの上部にある**新規作成**（{{< icon name="plus" >}}）と**新規プロジェクト/リポジトリ**を選択します。
1. **プロジェクトのインポート**を選択します。
1. 右上隅にある**履歴**リンクを選択します。
1. 特定のインポートにエラーがある場合は、**詳細**を選択して表示します。

履歴には、[組み込み](../_index.md#create-a-project-from-a-built-in-template)または[カスタム](../_index.md#create-a-project-from-a-custom-template)テンプレートから作成されたプロジェクトも含まれています。GitLab は[URL でリポジトリをインポート](repo_by_url.md)して、テンプレートから新しいプロジェクトを作成します。

## LFS オブジェクトを含むプロジェクトのインポート

LFS オブジェクトを含むプロジェクトをインポートする場合、プロジェクトにリポジトリ URL ホストとは異なる URL ホスト（`lfs.url`）を持つ[`.lfsconfig`](https://github.com/git-lfs/git-lfs/blob/main/docs/man/git-lfs-config.adoc)ファイルがある場合、LFS ファイルはダウンロードされません。

## プロフェッショナルサービスを利用して移行する

自分で移行する代わりに、GitLabプロフェッショナルサービスを利用してグループとプロジェクトを GitLab に移行することもできます。詳しくは、[プロフェッショナルサービスフルカタログ](https://about.gitlab.com/services/catalog/)をご覧ください。

## Sidekiq の設定

インポーターは、グループとプロジェクトのインポートおよびエクスポートを処理するために、Sidekiq ジョブに大きく依存しています。これらのジョブの中には、大量のリソース（CPUとメモリ）を消費し、完了までに長い時間がかかるものがあり、他のジョブの実行に影響を与える可能性があります。このイシューを解決するには、インポータージョブを専用のSidekiqキューにルーティングし、そのキューを処理するために専任のSidekiqプロセスを割り当てる必要があります。

たとえば、次の設定を使用できます:

```conf
sidekiq['concurrency'] = 20

sidekiq['routing_rules'] = [
  # Route import and export jobs to the importer queue
  ['feature_category=importers', 'importers'],

  # Route all other jobs to the default queue by using wildcard matching
  ['*', 'default']
]

sidekiq['queue_groups'] = [
  # Run a dedicated process for the importer queue
  'importers',

  # Run a separate process for the default and mailer queues
  'default,mailers'
]
```

この設定では、次のようになります:

- 専任のSidekiqプロセスは、インポーターキューを介してインポートおよびエクスポートジョブを処理します。
- 別のSidekiqプロセスは、他のすべてのジョブ（デフォルトキューとメーラーキュー）を処理します。
- 両方のSidekiqプロセスは、デフォルトで20スレッドの同時実行をするようにConfigureされています。メモリが制約された環境では、この数値を減らすことをお勧めします。

インスタンスに、より多くの同時ジョブをサポートするのに十分なリソースがある場合は、追加のSidekiqプロセスをConfigureして、移行を高速化できます。次に例を示します。

```conf
sidekiq['queue_groups'] = [
  # Run three processes for importer jobs
  'importers',
  'importers',
  'importers',

  # Run a separate process for the default and mailer queues
  'default,mailers'
]
```

この設定では、複数のSidekiqプロセスがインポートおよびエクスポートジョブを同時に処理するため、インスタンスに十分なリソースがある限り、移行が高速化されます。

Sidekiqプロセスの最大数については、次の点に注意してください:

- プロセスの数は、使用可能なCPUコアの数を超えないようにする必要があります。
- 各プロセスは最大2 GBのメモリを使用する可能性があるため、インスタンスに追加のプロセスに対応できる十分なメモリがあることを確認してください。
- 各プロセスは、`sidekiq['concurrency']`で定義されているように、スレッドごとに1つのデータベース接続を追加します。

詳細については、[複数のSidekiqプロセスの実行](../../../administration/sidekiq/extra_sidekiq_processes.md)および[特定のジョブクラスの処理](../../../administration/sidekiq/processing_specific_job_classes.md)を参照してください。

## トラブルシューティング

### インポートされたリポジトリにブランチがない

インポートされたリポジトリにソースリポジトリのすべてのブランチが含まれていない場合:

1. [環境変数](../../../administration/logs/_index.md#override-default-log-level) `IMPORT_DEBUG=true`を設定します。
1. [別のグループ、サブグループ、またはプロジェクト名](https://about.gitlab.com/releases/2023/02/22/gitlab-15-9-released/#re-import-projects-from-external-providers)を使用してインポートを再試行します。
1. 一部のブランチがまだ見つからない場合は、[`importer.log`](../../../administration/logs/_index.md#importerlog)（たとえば、[`jq`](../../../administration/logs/log_parsing.md#parsing-gitlab-railsimporterlog)を使用）を調べます。

### 例外:`Error Importing repository - No such file or directory @ rb_sysopen - (filename)`

このエラーは、リポジトリのソースコードの`tar.gz`ファイルダウンロードをインポートしようとすると発生します。

インポートには、単なるリポジトリのダウンロードファイルではなく、[GitLabエクスポート](../settings/import_export.md#export-a-project-and-its-data)ファイルが必要です。

### 長期化または失敗したインポートの診断

ファイルベースのインポート（特にS3を使用するインポート）で長期の遅延やエラーが発生している場合は、次の方法で問題の根本原因を特定できる可能性があります。

- [インポート手順の確認](#check-import-status)
- [log のレビュー](#review-logs)
- [一般的なイシューの特定](#identify-common-issues)

#### インポート状態の確認

インポート状態を確認します:

1. GitLab APIを使用して、影響を受けるプロジェクトの[インポート状態](../../../api/project_import_export.md#import-status)を確認します。
1. 特に`status`値と`import_error`値について、エラーメッセージまたは状態情報に対する応答をレビューします。
1. 応答の`correlation_id`に注意してください。これは、さらなるトラブルシューティングに不可欠です。

#### log のレビュー

関連情報についてlogを検索します。

GitLab Self-Managedインスタンスの場合:

1. [Sidekiq log](../../../administration/logs/_index.md#sidekiqlog)と[`exceptions_json`log](../../../administration/logs/_index.md#exceptions_jsonlog)を確認します。
1. `RepositoryImportWorker`および[インポート状態の確認](#check-import-status)からの相関IDに関連するエントリを検索します。
1. `job_status`、`interrupted_count`、`exception`などのフィールドを探します。

GitLab.comの場合（GitLabチームメンバーのみ）:

1. [Kibana](https://log.gprd.gitlab.net/)を使用して、次のようなクエリでSidekiq logを検索します。

   ターゲット:`pubsub-sidekiq-inf-gprd*`

   ```plaintext
   json.class: "RepositoryImportWorker" AND json.correlation_id.keyword: "<CORRELATION_ID>"
   ```

   または

   ```plaintext
   json.class: "RepositoryImportWorker" AND json.meta.project: "<project.full_path>"
   ```

1. GitLab Self-Managedインスタンスについて言及されているのと同じフィールドを探します。

#### 一般的なイシューの特定

[logの確認](#review-logs)で収集した情報を、次の一般的なイシューと照らし合わせてレビューします。

- **中断されたジョブ**:失敗を示す高い`interrupted_count`または`job_status`が表示された場合、インポートジョブが複数回中断され、デッドキューに配置された可能性があります。
- **S3接続**:S3を使用するインポートの場合は、logでS3関連のエラーメッセージを確認してください。
- **大きなリポジトリ**:リポジトリが非常に大きい場合、インポートがになる可能性があります。この場合は、[直接転送](../../group/import/_index.md)の使用を検討してください。
