---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: Git basics.
title: 'チュートリアル: Gitについて学ぶ'
---

GitLabはGitベースのプラットフォームであるため、Gitを理解することはGitLabを最大限に活用するために重要です。

| トピック | 説明 | 初心者向け |
|-------|-------------|--------------------|
| [初めてのGitコミットを行う](make_first_git_commit/_index.md) | プロジェクトを作成し、ファイルを編集し、コマンドラインからGitリポジトリに変更をコミットします | {{< icon name="star" >}} |
| [コマンドラインでGitの使用を開始する](../topics/git/commands.md) | Gitをセットアップし、リポジトリのクローンを作成し、ブランチを操作する方法について学習します | {{< icon name="star" >}} |
| [Gitリベースを活用する](https://about.gitlab.com/blog/2022/10/06/take-advantage-of-git-rebase/) | ワークフローで`rebase`コマンドを使用する方法について学習します | |
| [Gitコミットメッセージを更新する](update_commit_messages/_index.md) | コミットメッセージを更新し、変更をGitLabにプッシュする方法について学習します | |
| [Gitチートシート](https://about.gitlab.com/images/press/git-cheat-sheet.pdf) | 一般的なGitコマンドのPDFをダウンロードします | |
| [Git-ing started with Git](https://www.youtube.com/watch?v=Ce5nz5n41z4)（GitでGitを開始する（英語）） | Gitの基本に関する動画チュートリアル | |
| [GitLabソースコード管理のチュートリアル](https://www.youtube.com/watch?v=wTQ3aXJswtM) | GitLabワークフローに関する動画チュートリアル | |
