# frozen_string_literal: true

class AddIndexOnVulnerabilityReadsForFilteredRemoval < Gitlab::Database::Migration[2.2]
  INDEX_NAME = 'index_vulnerability_reads_for_filtered_removal'

  disable_ddl_transaction!

  milestone '17.5'

  # -- Legacy migration
  def up
    # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
    add_concurrent_index :vulnerability_reads, %i[project_id resolved_on_default_branch], name: INDEX_NAME
    # rubocop:enable Migration/PreventIndexCreation
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
