# frozen_string_literal: true

# See https://docs.gitlab.com/ee/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.

class AddForeignKeyToVulnerabilityOccurrencesOnSecretDetectionTokenStatus < Gitlab::Database::Migration[2.2]
  milestone '17.11'
  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :secret_detection_token_statuses, :vulnerability_occurrences,
      column: :vulnerability_occurrence_id, on_delete: :cascade, reverse_lock_order: true
  end

  def down
    with_lock_retries do
      remove_foreign_key_if_exists :secret_detection_token_statuses, column: :vulnerability_occurrence_id,
        reverse_lock_order: true
    end
  end
end
