# frozen_string_literal: true

class AddForeignKeyToVulnerabilityRepresentationInformation < Gitlab::Database::Migration[2.2]
  milestone '17.6'
  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :vulnerability_representation_information, :vulnerabilities, column: :vulnerability_id,
      on_delete: :cascade
  end

  def down
    with_lock_retries do
      remove_foreign_key_if_exists :vulnerability_representation_information, column: :vulnerability_id
    end
  end
end
