/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.debug;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import java.util.List;

public class FidFunctionRecordTableModel
extends AbstractSortedTableModel<FunctionRecord> {
    static final int NAME_COL = 0;
    static final int FID_COL = 1;
    static final int LIB_COL = 2;
    static final int PATH_COL = 3;
    static final int FH_COL = 4;
    static final int CUS_COL = 5;
    static final int XH_COL = 6;
    static final int XHS_COL = 7;
    static final int WARN_COL = 8;
    private final FidQueryService service;
    private List<FunctionRecord> functionRecords;

    public FidFunctionRecordTableModel(FidQueryService service, List<FunctionRecord> functionRecords) {
        this.service = service;
        this.functionRecords = functionRecords;
    }

    public String getName() {
        return "Fid Functions";
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public int getColumnCount() {
        return 9;
    }

    public List<FunctionRecord> getModelData() {
        return this.functionRecords;
    }

    public void resetWholeTable(List<FunctionRecord> newRecords) {
        this.functionRecords = newRecords;
        this.fireTableDataChanged();
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 5 || columnIndex == 7) {
            return Integer.class;
        }
        return String.class;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 1: {
                return "Function ID";
            }
            case 2: {
                return "Library";
            }
            case 3: {
                return "Domain Path";
            }
            case 0: {
                return "Name";
            }
            case 4: {
                return "Full Hash";
            }
            case 5: {
                return "Code Unit Size";
            }
            case 6: {
                return "Specific Hash";
            }
            case 7: {
                return "Spec. +Size";
            }
            case 8: {
                return "Warn";
            }
        }
        return "<<UNKNOWN>>";
    }

    public Object getColumnValueForRow(FunctionRecord t, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return String.format("0x%016x", t.getID());
            }
            case 2: {
                LibraryRecord libraryRecord = this.service.getLibraryForFunction(t);
                return String.format("%s %s %s", libraryRecord.getLibraryFamilyName(), libraryRecord.getLibraryVersion(), libraryRecord.getLibraryVariant());
            }
            case 3: {
                return t.getDomainPath();
            }
            case 0: {
                return t.getName();
            }
            case 4: {
                return String.format("0x%016x", t.getFullHash());
            }
            case 5: {
                return (int)t.getCodeUnitSize();
            }
            case 6: {
                return String.format("0x%016x", t.getSpecificHash());
            }
            case 7: {
                return (int)t.getSpecificHashAdditionalSize();
            }
            case 8: {
                return String.format("%s%s%s%s%s", t.autoFail() ? "F" : " ", t.autoPass() ? "P" : " ", t.hasTerminator() ? " " : "U", t.isForceSpecific() ? "S" : " ", t.isForceRelation() ? "R" : " ");
            }
        }
        return "<<INTERNAL ERROR>>";
    }
}

