/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.widgets.table.ObjectSelectedListener;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.pcode.HighVariable;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaintLabelsDataFrame
implements ObjectSelectedListener<Map<String, Object>> {
    private List<String> columns;
    public List<Map<String, Object>> tableResults;
    private TaintPlugin plugin;

    public TaintLabelsDataFrame(TaintPlugin plugin) {
        this.plugin = plugin;
        this.columns = new ArrayList<String>();
        this.tableResults = new ArrayList<Map<String, Object>>();
        this.columns.add("Selected");
        this.columns.add("Address");
        this.columns.add("Label");
        this.columns.add("Name");
        this.columns.add("Category");
        this.columns.add("Function Address");
        this.columns.add("Taint Label Object");
        Msg.info((Object)this, (Object)"Created TaintLabelsDataFrame");
    }

    public List<String> getColumnHeaders() {
        return this.columns;
    }

    public void loadData() {
        this.tableResults = new ArrayList<Map<String, Object>>();
        Msg.info((Object)this, (Object)"Loading TaintLabelsDataFrame");
        for (TaintState.MarkType category : new TaintState.MarkType[]{TaintState.MarkType.SOURCE, TaintState.MarkType.SINK, TaintState.MarkType.GATE}) {
            for (TaintLabel taint_label : this.plugin.getTaintState().getTaintLabels(category)) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                HighVariable hv = taint_label.getHighVariable();
                if (hv == null) {
                    row.put("Name", taint_label.getFunctionName());
                    row.put("Function Address", null);
                    row.put("Address", null);
                } else {
                    row.put("Name", hv.getName());
                    row.put("Function Address", hv.getHighFunction().getFunction().getEntryPoint());
                    Address addr = hv.getSymbol() == null ? null : hv.getSymbol().getPCAddress();
                    row.put("Address", addr);
                }
                row.put("Label", taint_label.getLabel());
                row.put("Taint Label Object", taint_label);
                row.put("Category", (Object)category);
                row.put("Selected", taint_label.isActive());
                Msg.info((Object)this, (Object)("Row loaded: " + taint_label.toString()));
                this.tableResults.add(row);
            }
        }
    }

    public void setSelected(int row, Boolean value) {
        Map<String, Object> row_data = this.tableResults.get(row);
        row_data.put("Selected", value);
    }

    public void toggleSelected(int row) {
        Map<String, Object> rowData;
        Boolean status = (Boolean)(rowData = this.tableResults.get(row)).get("Selected");
        rowData.put("Selected", status == false);
    }

    public void setLabel(int row, String label) {
        this.tableResults.get(row).put("Label", label);
        Msg.info((Object)this, (Object)("New label value: " + String.valueOf(this.tableResults.get(row).get("Label"))));
    }

    public AddressSet getTaintAddressSet() {
        AddressSet aset = new AddressSet();
        if (this.tableResults != null && this.tableResults.size() > 0) {
            for (Map<String, Object> map : this.tableResults) {
                aset.add((Address)map.get("Address"));
            }
        }
        return aset;
    }

    public void dumpTableToDebug() {
        for (Map<String, Object> row : this.tableResults) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                sb.append(String.format("(%s,%s), ", entry.getKey(), entry.getValue()));
            }
            Msg.info((Object)this, (Object)sb.toString());
        }
    }

    public void objectSelected(Map<String, Object> row) {
        if (row != null && row.containsKey("Address")) {
            ArrayList<Address> addr_list = new ArrayList<Address>();
            addr_list.add((Address)row.get("Address"));
            Msg.info((Object)this, (Object)("Making selection, " + String.valueOf(row.get("Address"))));
            this.plugin.makeSelection(addr_list);
        }
    }

    public List<Map<String, Object>> getData() {
        return this.tableResults;
    }
}

