/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.CommentsDBAdapter;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class CommentsDBAdapterV0
extends CommentsDBAdapter {
    private static final int V0_EOL_COMMENT_COLUMN = 0;
    private static final int V0_PRE_COMMENT_COLUMN = 1;
    private static final int V0_POST_COMMENT_COLUMN = 2;
    private static final int V0_PLATE_COMMENT_COLUMN = 3;
    private Table commentTable;
    private AddressMap addrMap;

    public CommentsDBAdapterV0(DBHandle handle, AddressMap addrMap) throws IOException, VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.commentTable = handle.getTable("Comments");
        if (this.commentTable == null) {
            throw new VersionException("Missing Table: Comments");
        }
        if (this.commentTable.getSchema().getVersion() != 0) {
            throw new VersionException(2, false);
        }
    }

    @Override
    public DBRecord getRecord(long addr) throws IOException {
        return this.v0ConvertRecord(this.commentTable.getRecord(addr));
    }

    @Override
    public DBRecord createRecord(long addr, int commentCol, String comment) throws IOException {
        return null;
    }

    @Override
    public boolean deleteRecord(long addr) throws IOException {
        return false;
    }

    @Override
    public boolean deleteRecords(Address start, Address end) throws IOException {
        return false;
    }

    @Override
    public void updateRecord(DBRecord commentRec) throws IOException {
    }

    @Override
    public AddressKeyIterator getKeys(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyIterator(this.commentTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyIterator(this.commentTable, this.addrMap, start, end, end, false);
    }

    @Override
    public AddressKeyIterator getKeys(AddressSetView set, boolean forward) throws IOException {
        if (forward) {
            return new AddressKeyIterator(this.commentTable, this.addrMap, set, set.getMinAddress(), true);
        }
        return new AddressKeyIterator(this.commentTable, this.addrMap, set, set.getMaxAddress(), false);
    }

    @Override
    public RecordIterator getRecords(Address start, Address end, boolean atStart) throws IOException {
        AddressKeyRecordIterator it = null;
        it = atStart ? new AddressKeyRecordIterator(this.commentTable, this.addrMap, start, end, start, true) : new AddressKeyRecordIterator(this.commentTable, this.addrMap, start, end, end, false);
        return new RecordIteratorAdapter(it);
    }

    @Override
    public RecordIterator getRecords(Address addr) throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.commentTable, this.addrMap, addr, true));
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new RecordIteratorAdapter(new AddressKeyRecordIterator(this.commentTable, this.addrMap));
    }

    @Override
    public void putRecord(DBRecord record) throws IOException {
    }

    @Override
    public int getRecordCount() throws IOException {
        return this.commentTable.getRecordCount();
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    private DBRecord v0ConvertRecord(DBRecord recV0) {
        if (recV0 == null) {
            return null;
        }
        DBRecord record = COMMENTS_SCHEMA.createRecord(recV0.getKey());
        String comment = recV0.getString(0);
        if (comment != null) {
            record.setString(EOL_COMMENT_COL, comment);
        }
        if ((comment = recV0.getString(1)) != null) {
            record.setString(PRE_COMMENT_COL, comment);
        }
        if ((comment = recV0.getString(2)) != null) {
            record.setString(POST_COMMENT_COL, comment);
        }
        if ((comment = recV0.getString(3)) != null) {
            record.setString(PLATE_COMMENT_COL, comment);
        }
        return record;
    }

    class RecordIteratorAdapter
    implements RecordIterator {
        RecordIterator it;

        RecordIteratorAdapter(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            return false;
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            DBRecord rec = this.it.next();
            return CommentsDBAdapterV0.this.v0ConvertRecord(rec);
        }

        public DBRecord previous() throws IOException {
            DBRecord rec = this.it.previous();
            return CommentsDBAdapterV0.this.v0ConvertRecord(rec);
        }
    }
}

