/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import utilities.util.FileUtilities;
import utility.application.ApplicationUtilities;
import utility.module.ModuleUtilities;

public class TestApplicationUtils {
    private static File getCurrentRepoDirectory() {
        String userDir = System.getProperty("user.dir");
        File repo = ModuleUtilities.findRepo((File)new File(userDir));
        return repo;
    }

    private static File getRepoContainerDirectory() {
        File repo = TestApplicationUtils.getCurrentRepoDirectory();
        if (repo == null) {
            return null;
        }
        File repoContainer = repo.getParentFile();
        return repoContainer;
    }

    public static File getInstallationDirectory() {
        File repo = TestApplicationUtils.getCurrentRepoDirectory();
        if (repo != null) {
            return repo;
        }
        File jarFile = SystemUtilities.getSourceLocationForClass(SystemUtilities.class);
        if (jarFile == null || !jarFile.getName().endsWith(".jar")) {
            throw new AssertException("Unable to determine the installation directory");
        }
        List parts = FileUtilities.pathToParts((String)jarFile.getAbsolutePath());
        int last = parts.size() - 1;
        int installDir = last - 5;
        String path = StringUtils.join(parts.subList(0, installDir + 1), (String)File.separator);
        return new File(path);
    }

    public static File getUniqueTempDir() {
        File reposContainer = TestApplicationUtils.getRepoContainerDirectory();
        if (reposContainer == null) {
            File installDir;
            reposContainer = installDir = TestApplicationUtils.getInstallationDirectory();
        }
        try {
            File tmpDir = ApplicationUtilities.getDefaultUserTempDir((String)"ghidra");
            String name = reposContainer.getName();
            return new File(tmpDir, name);
        }
        catch (IOException e) {
            throw new AssertException((Throwable)e);
        }
    }
}

