/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.hyper;

import ghidra.util.database.spatial.BoundingShape;
import ghidra.util.database.spatial.hyper.EuclideanHyperSpace;
import ghidra.util.database.spatial.hyper.HyperPoint;
import java.util.Objects;

public interface HyperBox<P extends HyperPoint, B extends HyperBox<P, B>>
extends BoundingShape<B> {
    public EuclideanHyperSpace<P, B> space();

    default public boolean doEquals(Object obj) {
        if (!(obj instanceof HyperBox)) {
            return false;
        }
        HyperBox that = (HyperBox)obj;
        if (this.space() != that.space()) {
            return false;
        }
        return this.space().boxesEqual(this, that);
    }

    default public int doHashCode() {
        return Objects.hash(this.space().collectBounds(this));
    }

    default public boolean contains(P p) {
        return this.space().boxContains(this, p);
    }

    @Override
    default public double getArea() {
        return this.space().boxArea(this);
    }

    @Override
    default public double getMargin() {
        return this.space().boxMargin(this);
    }

    default public P getCenter() {
        return this.space().boxCenter(this);
    }

    @Override
    default public double computeAreaUnionBounds(B shape) {
        return this.space().computeAreaUnionBounds(this, (HyperBox)shape);
    }

    @Override
    default public double computeAreaIntersection(B shape) {
        return this.space().computeAreaIntersection(this, (HyperBox)shape);
    }

    @Override
    default public double computeCentroidDistance(B shape) {
        return this.space().sqDistance(this.getCenter(), shape.getCenter());
    }

    @Override
    default public B unionBounds(B shape) {
        return (B)this.space().boxUnionBounds(this, (HyperBox)shape);
    }

    @Override
    default public boolean encloses(B shape) {
        return this.space().boxEncloses(this, (HyperBox)shape);
    }

    public P lCorner();

    public P uCorner();

    public B immutable(P var1, P var2);

    default public B intersection(B shape) {
        return (B)this.space().boxIntersection(this, (HyperBox)shape);
    }
}

