/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexTypeDefOrRef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableTypeDef
extends CliAbstractTable {
    public CliTableTypeDef(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliTypeDefRow row = new CliTypeDefRow(reader.readNextInt(), this.readStringIndex(reader), this.readStringIndex(reader), CliIndexTypeDefOrRef.readCodedIndex(reader, stream), this.readTableIndex(reader, CliTypeTable.Field), this.readTableIndex(reader, CliTypeTable.MethodDef));
            this.rows.add(row);
            this.strings.add(row.typeNameIndex);
            this.strings.add(row.typeNamespaceIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public int getOwnerOfFieldIndex(int fieldIndex) {
        for (int i = 0; i < this.numRows; ++i) {
            CliTypeDefRow row = (CliTypeDefRow)this.rows.get(i);
            if (i == this.numRows - 1) {
                if (fieldIndex >= row.fieldListIndex) {
                    return i + 1;
                }
                return -1;
            }
            CliTypeDefRow nextRow = (CliTypeDefRow)this.rows.get(i + 1);
            if (fieldIndex < row.fieldListIndex || fieldIndex >= nextRow.fieldListIndex) continue;
            return i + 1;
        }
        return -1;
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "TypeDef Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumTypeAttributes.dataType, "Flags", "see CorTypeAttr");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "TypeName", "index into String heap");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "TypeNamespace", "index into String heap");
        rowDt.add(CliIndexTypeDefOrRef.toDataType(this.metadataStream), "Extends", "index: coded TypeDefOrRef");
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.Field), "FieldList", "index into Field table");
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.MethodDef), "MethodList", "index into MethodDef table");
        return rowDt;
    }

    public class CliTypeDefRow
    extends CliAbstractTableRow {
        public int flags;
        public int typeNameIndex;
        public int typeNamespaceIndex;
        public int extendsIndex;
        public int fieldListIndex;
        public int methodListIndex;

        public CliTypeDefRow(int flags, int typeNameIndex, int typeNamespaceIndex, int extendsIndex, int fieldListIndex, int methodListIndex) {
            this.flags = flags;
            this.typeNameIndex = typeNameIndex;
            this.typeNamespaceIndex = typeNamespaceIndex;
            this.extendsIndex = extendsIndex;
            this.fieldListIndex = fieldListIndex;
            this.methodListIndex = methodListIndex;
        }

        @Override
        public String getShortRepresentation() {
            return String.format("%s.%s", CliTableTypeDef.this.metadataStream.getStringsStream().getString(this.typeNamespaceIndex), CliTableTypeDef.this.metadataStream.getStringsStream().getString(this.typeNameIndex));
        }

        @Override
        public String getRepresentation() {
            String extendsRep;
            if (this.extendsIndex == 0) {
                extendsRep = "Nothing";
            } else {
                try {
                    extendsRep = CliTableTypeDef.this.getRowRepresentationSafe(CliIndexTypeDefOrRef.getTableName(this.extendsIndex), CliIndexTypeDefOrRef.getRowIndex(this.extendsIndex));
                }
                catch (InvalidInputException e) {
                    extendsRep = Integer.toHexString(this.extendsIndex);
                }
            }
            return String.format("Type %s Namespace %s Extends %s Fields %s MethodList %s Flags %s", CliTableTypeDef.this.metadataStream.getStringsStream().getString(this.typeNameIndex), CliTableTypeDef.this.metadataStream.getStringsStream().getString(this.typeNamespaceIndex), extendsRep, CliTableTypeDef.this.getRowRepresentationSafe(CliTypeTable.Field, this.fieldListIndex), CliTableTypeDef.this.getRowRepresentationSafe(CliTypeTable.MethodDef, this.methodListIndex), CliFlags.CliEnumTypeAttributes.dataType.getName(this.flags & 0xFFFFFFFF));
        }
    }
}

